package com.plugins.junk.utils;


import java.util.Random;

import javassist.CtMethod;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LineNumberAttribute;
import javassist.bytecode.MethodInfo;

public class RandomUtil {
    private static final char[] abcNumber = "abcdefghijklmnopqrstuvwxyz1234567890".toCharArray();
    private static final char[] abc = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] number = "1234567890".toCharArray();
    private static final char[] specialSymbols = ",!@#$%&*;|][".toCharArray();
    private static final String[] mModifiers = new String[]{"public", "protected", ""};//不要加入private，插入代码的项目会报错
    private static final String[] mFieldModifiers = new String[]{"public", "protected", "private", ""};
    private static final String[] mInterfaceModifiers = new String[]{"public", ""};
    private static final String[] mModifiers2 = new String[]{"", " final"};
    private static final String[] mCalculationSymbols = new String[]{"-", "+", "*"};
    private static final String[] mJudgeSymbols = new String[]{"==", ">", "<", ">=", "<=", "!="};
    private static final String[] mLogicSymbols = new String[]{"&&", "||"};
    private static final Random mRandom = new Random();


    public static Random getRandom() {
        return mRandom;
    }

    /**
     * 构建随机名称
     *
     * @return
     */
    public static String getName() {
        return getString(RandomUtil.getRandom().nextInt(8) + 5);
    }

    /**
     * 构建随机String
     *
     * @return
     */
    public static String getString() {
        return getString(getRandom().nextInt(3) + 2);
    }

    public static String getString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            if (i != 0)
                sb.append(abcNumber[getRandom().nextInt(abcNumber.length)]);
            else
                sb.append(abc[getRandom().nextInt(abc.length)]);
        }
        return sb.toString();
    }

    /**
     * 获取随机方法行数
     *
     * @param ctMethod
     * @return
     */
    public static int getMethodLine(CtMethod ctMethod) {
        MethodInfo methodInfo = ctMethod.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        int codeLines = methodInfo.getLineNumber(0);
        try {
            LineNumberAttribute lineNumberAttribute = (LineNumberAttribute) codeAttribute.getAttribute(LineNumberAttribute.tag);
            if (lineNumberAttribute != null && lineNumberAttribute.tableLength() > 1) {
                return codeLines + getRandom().nextInt(lineNumberAttribute.tableLength() - 1);
            }
        } catch (Exception e) {
        }
        return codeLines;
    }

    /**
     * 获取随机的方法修饰符
     *
     * @return
     */
    public static String getMethodModifier(boolean isStatic, boolean isInterface) {
        StringBuilder stringBuilder = new StringBuilder();
        if (isInterface) {
            stringBuilder.append(mInterfaceModifiers[getRandom().nextInt(mInterfaceModifiers.length)]);
        } else {
            stringBuilder.append(mModifiers[getRandom().nextInt(mModifiers.length)]);
        }

        stringBuilder.append(mModifiers2[getRandom().nextInt(mModifiers2.length)]);
        if (isStatic) {
            stringBuilder.append(" static");
        }
        return stringBuilder.toString();
    }

    /**
     * 获取随机的变量修饰符
     *
     * @return
     */
    public static String getFieldModifier(boolean isStatic) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(mFieldModifiers[getRandom().nextInt(mFieldModifiers.length)]);
        if (isStatic) {
            stringBuilder.append(" static");
        }
        return stringBuilder.toString();
    }

    /**
     * 获取随机计算符号
     *
     * @return
     */
    public static String getCalculationSymbols() {
        return mCalculationSymbols[getRandom().nextInt(mCalculationSymbols.length)];
    }

    /**
     * 获取随机判断符号
     *
     * @return
     */
    public static String getJudgeSymbols() {
        return mJudgeSymbols[getRandom().nextInt(mJudgeSymbols.length)];
    }

    /**
     * 获取随机逻辑符号
     *
     * @return
     */
    public static String getLogicSymbols() {
        return mLogicSymbols[getRandom().nextInt(mLogicSymbols.length)];
    }

    /**
     * 获取随机单个字母数字
     *
     * @return
     */
    public static String getAbcNumber() {
        return String.valueOf(abcNumber[getRandom().nextInt(abcNumber.length)]);
    }
    /**
     * 获取随机数字字符串
     *
     * @return
     */
    public static String getNumber(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; i++) {
            stringBuilder.append(number[getRandom().nextInt(number.length)]);
        }
        return stringBuilder.toString();

    }

    /**
     * 获取随机单个特殊符号
     *
     * @return
     */
    public static String getSpecialSymbols() {
        return String.valueOf(specialSymbols[getRandom().nextInt(specialSymbols.length)]);
    }

    /**
     * 获取字符串数组，长度最小1最大3
     *
     * @return
     */
    public static String getStringArray(String name) {
        return getStringArray(name, getRandom().nextInt(3) + 1);
    }

    /**
     * 获取指定长度字符串数组
     *
     * @return
     */
    public static String getStringArray(String name, int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("String[] ").append(name).append(" = {");
        for (int i = 0; i < length; i++) {
            stringBuilder.append("\"").append(getString()).append(getString()).append("\"");
            if (i != length - 1) {
                stringBuilder.append(",");
            }
        }
        stringBuilder.append("};\n");
        return stringBuilder.toString();
    }

    /**
     * 获取int数组，长度最小1最大3
     *
     * @return
     */
    public static String getIntArray(String name) {
        return getIntArray(name, getRandom().nextInt(3) + 1);
    }

    public static String getIntArray(String name, int length) {
        StringBuilder sb = new StringBuilder();
        sb.append("int[] ").append(name).append(" = {");
        for (int i = 0; i < length; i++) {
            sb.append(RandomUtil.getRandom().nextInt(100) + 1);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("};\n");
        return sb.toString();
    }
}
