package com.plugins.junk;

import org.gradle.api.Project;

public class CodeExtension {

    public static final String NAME = "code";

    /**
     * 是否开启垃圾代码注入
     */
    public boolean codeInjectEnable;

//    /**
//     * 垃圾变量注入比例（按照类现有方法的比例）, 取值范围[0,∞), 默认 1.0f（1比1）
//     */
//    public float codeInjectFieldRatio = 1.0f;

    /**
     * 垃圾代码注入百分比,默认 100
     */
    public int codeInjectPercentage = 100;

    /**
     * 垃圾方法注入比例（按照类现有方法的比例）, 取值范围[0,∞), 默认 1.0f（1比1）
     */
    public float codeInjectMethodRatio = 1.0f;

    /**
     * 垃圾代码白名单，名单中的类不会插入垃圾代码（传入类名即可: MainActivity）,默认全部类插入
     */
    public String[] codeInjectWhiteList = null;

    /**
     * 创建扩展
     *
     * @param project
     */
    public static void create(Project project) {
        project.getExtensions().create(NAME, CodeExtension.class);
    }
}
