package com.plugins.junk.method.create.code1;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode5 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            String judgeSymbols = RandomUtil.getJudgeSymbols();
            String content7 = RandomUtil.getAbcNumber();
            String content8 = RandomUtil.getAbcNumber() + RandomUtil.getAbcNumber();
            String method = modifier + " void " + name + "(String[] ctMethods, int size) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        if (size == 0)\n" +
                    "            return;\n" +
                    "        int index = 0;\n" +
                    "        for (int i = 0; i < size; i++) {\n" +
                    "            int length = i % ctMethods.length;\n" +
                    "            String ctMethod = ctMethods[length];\n" +
                    "            try {\n" +
                    "                ctMethods[length] = ctMethod.replace(\"" + content7 + "\",\"" + content8 + "\");\n" +
                    "                index++;\n" +
                    "                if (index " + judgeSymbols + " size) {\n" +
                    "                    index = 0;\n" +
                    "                }\n" +
                    "            } catch (Exception e) {\n" +
                    "                if (size < (size * 2)) {\n" +
                    "                    size++;\n" +
                    "                }\n" +
                    "            }\n" +
                    "        }\n" +
                    "    }";
            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    int nextInt = RandomUtil.getRandom().nextInt(2) + 1;
                    int size = RandomUtil.getRandom().nextInt(4) + 1;
                    String arrayName = "yf6dhfj";
                    String array = RandomUtil.getStringArray(arrayName,size);
                    return array + name + "(" + arrayName + ", " + nextInt + ");";
                }
            };
        } catch (Exception e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    private void insertCreateMethod(String[] ctMethods, int size, String var1, String var2) {
        if (size == 0)
            return;
        int index = 0;
        for (int i = 0; i < size; i++) {
            int length = i % ctMethods.length;
            String ctMethod = ctMethods[length];
            try {
                ctMethods[length] = ctMethod.replace(var1, var2);
                index++;
                if (index >= size) {
                    index = 0;
                }
            } catch (Exception e) {
                if (size < (size * 2)) {
                    size++;
                }
            }
        }
    }

}
