package com.plugins.junk.method.create.code1;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode6 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int int1 = RandomUtil.getRandom().nextInt(10) + 1;
            String abc1 = RandomUtil.getAbcNumber();
            String abc2 = RandomUtil.getAbcNumber();
            String judgeSymbols = RandomUtil.getJudgeSymbols();
            String method = modifier + " int " + name + "(String method, int codeInjectPercentage) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        int methodSuccessCount = 0;\n" +
                    "        int methodCurIndex = 0;\n" +
                    "        if (method != null) {\n" +
                    "           try{" +
                    "                String ctMethod = method;\n" +
                    "                if (ctMethod.contains(\"" + abc1 + "\")) {\n" +
                    "                    return methodSuccessCount;\n" +
                    "                }\n" +
                    "                boolean success = true;\n" +
                    "                if (codeInjectPercentage > methodCurIndex) {\n" +
                    "                    success = !ctMethod.startsWith(\"" + abc2 + "\");\n" +
                    "                    if (success) {\n" +
                    "                        methodSuccessCount++;\n" +
                    "                    }\n" +
                    "                }\n" +
                    "                if (success) {\n" +
                    "                    methodCurIndex++;\n" +
                    "                    if (methodCurIndex "+judgeSymbols+" " + int1 + ")\n" +
                    "                        methodCurIndex = 0;\n" +
                    "                }\n" +
                    "           }catch (Exception e) {\n" +
                    "           }\n" +
                    "        }\n" +
                    "        return methodSuccessCount;\n" +
                    "    }";
            CtMethod ctMethod = CtNewMethod.make(method, ctClass);

            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    int nextInt = RandomUtil.getRandom().nextInt(10) + 1;
                    String specialSymbols = RandomUtil.getSpecialSymbols();
                    String content1 = RandomUtil.getString();
                    String content2 = RandomUtil.getString() + RandomUtil.getString();
                    String content = content1 + specialSymbols + content2;
                    return name + "(\"" + content + "\", " + nextInt + ");";
                }
            };
        } catch (Exception e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    private int injectClassMethod(String method, int codeInjectPercentage) {
        int methodSuccessCount = 0;
        int methodCurIndex = 0;
        if (method != null) {
            String[] ctMethods = method.split(",");
            for (int i = 0; i < ctMethods.length; i++) {
                String ctMethod = ctMethods[i];
                if (ctMethod.contains("a")) {
                    continue;
                }
                boolean success = true;
                if (codeInjectPercentage > methodCurIndex) {
                    success = !ctMethod.startsWith("b");
                    if (success) {
                        methodSuccessCount++;
                    }
                }
                if (success) {
                    methodCurIndex++;
                    if (methodCurIndex == 10)
                        methodCurIndex = 0;
                }
            }
        }
        return methodSuccessCount;
    }

}
