package com.plugins.junk.method.create.code1;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode7 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            String abc = RandomUtil.getAbcNumber();
            String calculationSymbols = RandomUtil.getCalculationSymbols();
            String judgeSymbols = RandomUtil.getJudgeSymbols();
            String judgeSymbols2 = RandomUtil.getJudgeSymbols();
            String judgeSymbols3 = RandomUtil.getJudgeSymbols();
            String specialSymbols = RandomUtil.getSpecialSymbols();
            int nextInt = (RandomUtil.getRandom().nextInt(10) + 1) * 10;
            int nextInt2 = (RandomUtil.getRandom().nextInt(10) + 1) * 10;
            String method = modifier + " void " + name + "(StringBuilder methods, String[] ctMethods, float methodInjectProportion) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "    if (ctMethods != null) {\n" +
                    "            int count = (int) (ctMethods.length " + calculationSymbols + " methodInjectProportion);\n" +
                    "            if (count > 0) {\n" +
                    "                float staticCount = 0;\n" +
                    "                for (int i = 0; i < count; i++) {\n" +
                    "                    if (i < ctMethods.length) {" +
                    "                      String ctMethod = ctMethods[i];\n" +
                    "                      if (ctMethod.contains(\"" + abc + "\")) {\n" +
                    "                          staticCount++;\n" +
                    "                      }\n" +
                    "                    }\n" +
                    "                }\n" +
                    "                int percentage = (int) (staticCount " + judgeSymbols2 + " ctMethods.length " + judgeSymbols3 + " " + nextInt2 + ");\n" +
                    "                boolean isStatic = percentage " + judgeSymbols + " " + nextInt + ";\n" +
                    "                if (isStatic) {\n" +
                    "                    for (int i = 0; i < count; i++) {\n" +
                    "                        if (i < ctMethods.length) {\n" +
                    "                            methods.append(ctMethods[i]);\n" +
                    "                            methods.append(\""+specialSymbols+"\");\n" +
                    "                        }\n" +
                    "                    }\n" +
                    "                }\n" +
                    "            }\n" +
                    "        }\n" +
                    "    }";
            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    float nextFloat = (RandomUtil.getRandom().nextInt(10) + 1) / 10f;
                    String arrayName = "yf6dhfj";
                    String array = RandomUtil.getStringArray(arrayName);
                    return "java.lang.StringBuilder j4qofo = new java.lang.StringBuilder();\n" +
                            array +
                            name + "(j4qofo, " + arrayName + ", " + nextFloat + "f);";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }


    private static void createClassMethod(StringBuilder methods, String[] ctMethods, float methodInjectProportion) {
        if (ctMethods != null) {
            int count = (int) (ctMethods.length * methodInjectProportion);
            if (count > 0) {
                float staticCount = 0;
                for (int i = 0; i < count; i++) {
                    String ctMethod = ctMethods[i];
                    if (ctMethod.contains("b")) {
                        staticCount++;
                    }
                }
                int percentage = (int) (staticCount / ctMethods.length * 100);
                boolean isStatic = percentage >= 60;
                if (isStatic) {
                    for (int i = 0; i < count; i++) {
                        if (i < ctMethods.length) {
                            methods.append(ctMethods[i]);
                            methods.append(",");
                        }
                    }
                }
            }
        }
    }

}
