package com.plugins.junk.method.create.code2;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode28 implements CreateMethodCode {

    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            String judgeSymbols1 = RandomUtil.getJudgeSymbols();
            String judgeSymbols2 = RandomUtil.getJudgeSymbols();
            int i1 = RandomUtil.getRandom().nextInt(10);
            int i2 = RandomUtil.getRandom().nextInt(10);
            String s1 = RandomUtil.getString();

            String logic1 = RandomUtil.getLogicSymbols();
            String logic2 = RandomUtil.getLogicSymbols();
            String logic3 = RandomUtil.getLogicSymbols();

            String method = modifier + " String " + name + "(String[] sourceChar, int length) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "       if (sourceChar == null "+logic1+" sourceChar.length " + judgeSymbols1 + " " + i1 + " "+logic2+" length " + judgeSymbols2 + " " + i2 + ") {\n" +
                    "            return \"" + s1 + "\";\n" +
                    "        }\n" +
                    "        StringBuilder str = new StringBuilder(length);\n" +
                    "        java.util.Random random = new java.util.Random();\n" +
                    "        for (int i = 0; i < length; i++) {\n" +
                    "            str.append(sourceChar[random.nextInt(sourceChar.length)]);\n" +
                    "        }\n" +
                    "        return str.toString();\n" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod){
                @Override
                public String call() {
                    String content = RandomUtil.getString(6);
                    String stringArray = RandomUtil.getStringArray(content);
                    int i = RandomUtil.getRandom().nextInt(2) + 1;
                    return stringArray +
                            name + "(" + content + "," + i + ");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    private String template(String[] sourceChar, int length) {
        if (sourceChar == null || sourceChar.length == 0 || length < 0) {
            return null;
        }
        StringBuilder str = new StringBuilder(length);
        java.util.Random random = new java.util.Random();
        for (int i = 0; i < length; i++) {
            str.append(sourceChar[random.nextInt(sourceChar.length)]);
        }
        return str.toString();
    }


}
