package com.plugins.junk.method.create.code2;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode30 implements CreateMethodCode {

    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            String judgeSymbols1 = RandomUtil.getJudgeSymbols();
            String judgeSymbols2 = RandomUtil.getJudgeSymbols();
            String judgeSymbols3 = RandomUtil.getJudgeSymbols();
            String calculationSymbols = RandomUtil.getCalculationSymbols();
            int i1 = RandomUtil.getRandom().nextInt(1000) + 100;
            int i2 = RandomUtil.getRandom().nextInt(1000) + 100;
            int i3 = RandomUtil.getRandom().nextInt(1000) + 100;
            int i4 = RandomUtil.getRandom().nextInt(1000) + 100;
            int i5 = RandomUtil.getRandom().nextInt(2) + 3;
            int i6 = RandomUtil.getRandom().nextInt(i5);

            String logic1 = RandomUtil.getLogicSymbols();
            String logic2 = RandomUtil.getLogicSymbols();
            String logic3 = RandomUtil.getLogicSymbols();

            String method = modifier + " String " + name + "(String s) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        char[] source = s.toCharArray();\n" +
                    "        for (int i = 0; i < source.length; i++) {\n" +
                    "            if (source[i] " + judgeSymbols1 + " " + i1 + ") {\n" +
                    "                source[i] = ' ';\n" +
                    "            } else if (source[i] " + judgeSymbols2 + " " + i2 + " "+logic1+" source[i] " + judgeSymbols3 + " " + i3 + ") {\n" +
                    "                source[i] = (char) (source[i] " + calculationSymbols + " " + i4 + ");\n" +
                    "            } else {\n" +
                    "                source[i] = source["+i6+"];\n" +
                    "            }\n" +
                    "        }\n" +
                    "        return new String(source);\n" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    String content = RandomUtil.getString(i5);
                    return name + "(\"" + content + "\");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    private String template(String s) {
        char[] source = s.toCharArray();
        for (int i = 0; i < source.length; i++) {
            if (source[i] == 12288) {
                source[i] = ' ';
            } else if (source[i] >= 65281 && source[i] <= 65374) {
                source[i] = (char) (source[i] - 65248);
            } else {
                source[i] = source[2];
            }
        }
        return new String(source);
    }


}
