package com.plugins.junk.method.create.code2;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode32 implements CreateMethodCode {

    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);

            String s1 = RandomUtil.getString(RandomUtil.getRandom().nextInt(3) + 1);
            String s2 = RandomUtil.getString(RandomUtil.getRandom().nextInt(3) + 1);
            String s3 = RandomUtil.getString(RandomUtil.getRandom().nextInt(3) + 1);
            String s4 = RandomUtil.getString(RandomUtil.getRandom().nextInt(3) + 1);
            String s5 = RandomUtil.getString(RandomUtil.getRandom().nextInt(3) + 1);
            String s6 = RandomUtil.getString(RandomUtil.getRandom().nextInt(3) + 1);
            int i1 = RandomUtil.getRandom().nextInt(10);
            int i2 = RandomUtil.getRandom().nextInt(10);
            int i3 = RandomUtil.getRandom().nextInt(10);
            int i4 = RandomUtil.getRandom().nextInt(10);

            String logic1 = RandomUtil.getLogicSymbols();
            String logic2 = RandomUtil.getLogicSymbols();
            String logic3 = RandomUtil.getLogicSymbols();

            String method = modifier + " int " + name + "(String path) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        path = path.toLowerCase();\n" +
                    "        if (path.endsWith(\"" + s1 + "\") "+logic1+" path.endsWith(\"" + s2 + "\") "+logic2+" path.endsWith(\"" + s3 + "\")) {\n" +
                    "            return "+i1+";\n" +
                    "        } else if (path.endsWith(\"" + s4 + "\")) {\n" +
                    "            return "+i2+";\n" +
                    "        } else if (path.endsWith(\"" + s5 + "\") "+logic3+" path.endsWith(\"" + s6 + "\")) {\n" +
                    "            return "+i3+";\n" +
                    "        } else {\n" +
                    "            return "+i4+";\n" +
                    "        }\n" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod){
                @Override
                public String call() {
                    String content = RandomUtil.getString();
                    return name + "(\"" + content + "\");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }


    public int template(String path) {
        path = path.toLowerCase();
        if (path.endsWith(".doc") || path.endsWith(".docx") || path.endsWith(".xls")) {
            return 3;
        } else if (path.endsWith(".apk")) {
            return 2;
        } else if (path.endsWith(".zip") || path.endsWith(".rar")) {
            return 1;
        } else {
            return -1;
        }
    }


}
