package com.plugins.junk.method.create.code2;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode34 implements CreateMethodCode {

    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            String s2 = RandomUtil.getAbcNumber();

            String method = modifier + " String " + name + "(String hexStr) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
//                    "        hexStr = hexStr.replaceAll(\"" + s + "\", \"\");\n" +
                    "        char[] achar = hexStr.toCharArray();\n" +
                    "        StringBuilder result = new StringBuilder();\n" +
                    "        for (int i = 0; i < achar.length; i++) {\n" +
                    "            char a = achar[i];\n" +
                    "                result.append(a);\n" +
                    "                result.append(\"" + s2 + "\");\n" +
                    "        }\n" +
                    "        return result.toString();" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod){
                @Override
                public String call() {
                    String content = RandomUtil.getString();
                    return name + "(\"" + content + "\");";
                }
            };
        } catch (CannotCompileException e) {

            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public String template(String hexStr) {
        hexStr = hexStr.replaceAll("0x", "");
        char[] achar = hexStr.toCharArray();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < achar.length; i++) {
            char a = achar[i];
            try {
                int ii = Integer.valueOf(String.valueOf(a)).intValue();
                result.append(Integer.toBinaryString(ii));
                result.append(" ");
            } catch (Exception e) {
            }
        }
        return result.toString();
    }


}
