package com.plugins.junk.method.create.code2;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode39 implements CreateMethodCode {

    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            String abc = RandomUtil.getAbcNumber();
            String judgeSymbols = RandomUtil.getJudgeSymbols();
            int i = RandomUtil.getRandom().nextInt(5);

            String logic1 = RandomUtil.getLogicSymbols();
            String logic2 = RandomUtil.getLogicSymbols();
            String logic3 = RandomUtil.getLogicSymbols();

            String method = modifier + " String " + name + "(String s) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        if (s == null) {\n" +
                    "            return null;\n" +
                    "        }\n" +
                    "        StringBuilder sb = new StringBuilder();\n" +
                    "        boolean upperCase = false;\n" +
                    "        for (int i = 0; i < s.length(); i++) {\n" +
                    "            char c = s.charAt(i);\n" +
                    "            boolean nextUpperCase = true;\n" +
                    "            if (i < (s.length() - 1)) {\n" +
                    "                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));\n" +
                    "            }\n" +
                    "            if ((i "+judgeSymbols+" "+i+") "+logic1+" Character.isUpperCase(c)) {\n" +
                    "                if (!upperCase "+logic2+" !nextUpperCase) {\n" +
                    "                    sb.append(\"" + abc + "\");\n" +
                    "                }\n" +
                    "                upperCase = true;\n" +
                    "            } else {\n" +
                    "                upperCase = false;\n" +
                    "            }\n" +
                    "            sb.append(Character.toLowerCase(c));\n" +
                    "        }\n" +
                    "        return sb.toString();\n" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod){
                @Override
                public String call() {
                    String content = RandomUtil.getString();
                    return name + "(\"" + content + "\");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    private String template(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < (s.length() - 1)) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if ((i > 0) && Character.isUpperCase(c)) {
                if (!upperCase || !nextUpperCase) {
                    sb.append("_");
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }


}
