package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode42 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(10);
            int i2 = RandomUtil.getRandom().nextInt(10);
            int i3 = RandomUtil.getRandom().nextInt(10);
            int i4 = RandomUtil.getRandom().nextInt(2)+1;
            int i5 = RandomUtil.getRandom().nextInt(3)+1;
            String judge1 = RandomUtil.getJudgeSymbols();
            String judge2 = RandomUtil.getJudgeSymbols();
            String judge3 = RandomUtil.getJudgeSymbols();
            String judge4 = RandomUtil.getJudgeSymbols();

            String special1 = RandomUtil.getSpecialSymbols();

            String logic1 = RandomUtil.getLogicSymbols();
            String logic2 = RandomUtil.getLogicSymbols();
            String logic3 = RandomUtil.getLogicSymbols();

            String method = modifier + " String " + name + "(String color) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "      if (color == null) return null;\n" +
                    "        char[] chars = color.toCharArray();\n" +
                    "        int length = chars.length;\n" +
                    "        if (length "+judge1+" "+i1+" "+logic1+" chars[0] "+judge2+" '"+special1+"') {\n" +
                    "            if (length "+judge3+" "+i2+") {\n" +
                    "                String colorSub = color.substring("+i4+");\n" +
                    "                return color + colorSub;\n" +
                    "            } else if (length "+judge4+" "+i3+") {\n" +
                    "                String colorSub = color.substring("+i5+");\n" +
                    "                return color + colorSub + colorSub;\n" +
                    "            }\n" +
                    "        }\n" +
                    "        return color;"+
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    String s = RandomUtil.getName();
                    return name + "(\"" + s + "\");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static String template(String color) {
        if (color == null) return null;
        char[] chars = color.toCharArray();
        int length = chars.length;
        if (length != 0 && chars[0] == '#') {
            if (length == 4) {
                String colorSub = color.substring(1);
                return color + colorSub;
            } else if (length == 5) {
                String colorSub = color.substring(3);
                return color + colorSub + colorSub;
            }
        }
        return color;
    }
}
