package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode43 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(4) + 2;
            int i2 = RandomUtil.getRandom().nextInt(4) + 2;
            int i3 = RandomUtil.getRandom().nextInt(10) + 1;
            int i4 = RandomUtil.getRandom().nextInt(3) + 1;
            int i5 = RandomUtil.getRandom().nextInt(3) + 1;
            int i6 = RandomUtil.getRandom().nextInt(6) + 1;
            String judge = RandomUtil.getJudgeSymbols();
            String abcNumber = RandomUtil.getAbcNumber();
            String abcNumber2 = RandomUtil.getAbcNumber();

            String method = modifier + " byte[] " + name + "(String str) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "   if (str == null) return null;\n" +
                    "        try {\n" +
                    "            StringBuilder data = new StringBuilder(str);\n" +
                    "            int lenMod = data.length() % "+i1+";\n" +
                    "            int byteLen = data.length() / "+i2+";\n" +
                    "            if (lenMod "+judge+" "+i3+") {\n" +
                    "                for (int i = lenMod; i < "+i4+"; i++) {\n" +
                    "                    data.insert(0, \""+abcNumber+"\");\n" +
                    "                }\n" +
                    "                byteLen++;\n" +
                    "            }\n" +
                    "            byte[] bytes = new byte[byteLen];\n" +
                    "            for (int i = 0; i < byteLen; ++i) {\n" +
                    "                bytes[i] <<= "+i5+";\n" +
                    "                bytes[i] |= data.charAt(i * "+i6+" + i) - '"+abcNumber2+"';\n" +
                    "            }\n" +
                    "            return bytes;\n" +
                    "        } catch (Exception e) {\n" +
                    "        }\n" +
                    "        return null;" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    String i = RandomUtil.getString();
                    return name + "(\"" + i + "\");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static byte[] template(String str) {
        if (str == null) return null;
        try {
            StringBuilder data = new StringBuilder(str);
            int lenMod = data.length() % 8;
            int byteLen = data.length() / 8;
            if (lenMod != 0) {
                for (int i = lenMod; i < 8; i++) {
                    data.insert(0, "0");
                }
                byteLen++;
            }
            byte[] bytes = new byte[byteLen];
            for (int i = 0; i < byteLen; ++i) {
                bytes[i] <<= 1;
                bytes[i] |= data.charAt(i * 8 + i) - '0';
            }
            return bytes;
        } catch (Exception e) {
        }
        return null;
    }
}
