package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode45 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(1000) + 10;
            int i2 = RandomUtil.getRandom().nextInt(10)+2;
            int i3 = RandomUtil.getRandom().nextInt(10);

            String calculation = RandomUtil.getCalculationSymbols();

            String abc1 = RandomUtil.getAbcNumber();
            String abc2 = RandomUtil.getAbcNumber();
            String abc3 = RandomUtil.getAbcNumber();

            String s1 = RandomUtil.getString();

            String judge = RandomUtil.getJudgeSymbols();

            String method = modifier + " String " + name + "(boolean includeGmt, boolean includeMinuteSeparator, int offsetMillis) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        int offsetMinutes = offsetMillis "+calculation+" "+i1+";\n" +
                    "        char sign = '"+abc1+"';\n" +
                    "        if (offsetMinutes "+judge+" "+i3+") {\n" +
                    "            sign = '"+abc2+"';\n" +
                    "            offsetMinutes = -offsetMinutes;\n" +
                    "        }\n" +
                    "        StringBuilder builder = new StringBuilder();\n" +
                    "        if (includeGmt) {\n" +
                    "            builder.append(\""+s1+"\");\n" +
                    "        }\n" +
                    "        builder.append(sign);\n" +
                    "        if (includeMinuteSeparator) {\n" +
                    "            builder.append('"+abc3+"');\n" +
                    "        }\n" +
                    "        String string = Integer.toString(offsetMinutes % "+i2+");\n" +
                    "        builder.append(string);\n" +
                    "        return builder.toString();" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    boolean b1 = RandomUtil.getRandom().nextBoolean();
                    boolean b2 = RandomUtil.getRandom().nextBoolean();
                    int i = RandomUtil.getRandom().nextInt(100) + 10;
                    return name + "(" + b1 + ", "+b2+", "+i+");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static String template(boolean includeGmt, boolean includeMinuteSeparator, int offsetMillis) {
        int offsetMinutes = offsetMillis / 60000;
        char sign = '+';
        if (offsetMinutes < 0) {
            sign = '-';
            offsetMinutes = -offsetMinutes;
        }
        StringBuilder builder = new StringBuilder(9);
        if (includeGmt) {
            builder.append("GMT");
        }
        builder.append(sign);
        if (includeMinuteSeparator) {
            builder.append(':');
        }
        String string = Integer.toString(offsetMinutes % 60);
        builder.append(string);
        return builder.toString();
    }
}
