package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;


import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode53 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(100) + 10;
            int i2 = RandomUtil.getRandom().nextInt(100) + 10;
            int i3 = RandomUtil.getRandom().nextInt(28) + 1;
            int i4 = RandomUtil.getRandom().nextInt(28) + 1;

            String calculation1 = RandomUtil.getCalculationSymbols();
            String calculation2 = RandomUtil.getCalculationSymbols();
            String calculation3 = RandomUtil.getCalculationSymbols();
            String calculation4 = RandomUtil.getCalculationSymbols();

            String judge = RandomUtil.getJudgeSymbols();

            String method = modifier + " int " + name + "(long beginDate, long endDate) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        java.util.Calendar beginCalendar = java.util.Calendar.getInstance();\n" +
                    "        beginCalendar.setTimeInMillis(beginDate);\n" +
                    "        java.util.Calendar endCalendar = java.util.Calendar.getInstance();\n" +
                    "        endCalendar.setTimeInMillis(endDate);\n" +
                    "        long beginTime = beginCalendar.getTime().getTime();\n" +
                    "        long endTime = endCalendar.getTime().getTime();\n" +
                    "        int betweenDays = (int) ((endTime "+calculation1+" beginTime) "+calculation2+" "+i1+" "+calculation3+" "+i2+");\n" +
                    "        endCalendar.add(java.util.Calendar.DAY_OF_MONTH, -betweenDays);\n" +
                    "        endCalendar.add(java.util.Calendar.DAY_OF_MONTH, "+i3+");\n" +
                    "        if (beginCalendar.get(java.util.Calendar.DAY_OF_MONTH) "+judge+" endCalendar.get(java.util.Calendar.DAY_OF_MONTH)) {\n" +
                    "            return betweenDays "+calculation4+" "+i4+";\n" +
                    "        } else {\n" +
                    "            return betweenDays;\n" +
                    "        }" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    int ii1 = RandomUtil.getRandom().nextInt(10000) + 100;
                    int ii2 = RandomUtil.getRandom().nextInt(10000) + 100;
                    return name + "(" + ii1 + "L, "+ii2+"L);";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static int template(long beginDate, long endDate) {
        java.util.Calendar beginCalendar = java.util.Calendar.getInstance();
        beginCalendar.setTimeInMillis(beginDate);
        java.util.Calendar endCalendar = java.util.Calendar.getInstance();
        endCalendar.setTimeInMillis(endDate);
        long beginTime = beginCalendar.getTime().getTime();
        long endTime = endCalendar.getTime().getTime();
        int betweenDays = (int) ((endTime - beginTime) / (1000 * 60 * 60 * 24));
        endCalendar.add(java.util.Calendar.DAY_OF_MONTH, -betweenDays);
        endCalendar.add(java.util.Calendar.DAY_OF_MONTH, -1);
        if (beginCalendar.get(java.util.Calendar.DAY_OF_MONTH) == endCalendar.get(java.util.Calendar.DAY_OF_MONTH)) {
            return betweenDays + 1;
        } else {
            return betweenDays;
        }
    }
}
