package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode54 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(3) + 1;
            int i2 = RandomUtil.getRandom().nextInt(3) + 1;
            int i3 = RandomUtil.getRandom().nextInt(3) + 1;
            int i4 = RandomUtil.getRandom().nextInt(3) + 1;
            int i5 = RandomUtil.getRandom().nextInt(3) + 1;
            int i6 = RandomUtil.getRandom().nextInt(8) + 1;
            int i7 = RandomUtil.getRandom().nextInt(8) + 1;

            String judge1 = RandomUtil.getJudgeSymbols();
            String judge2 = RandomUtil.getJudgeSymbols();
            String judge3 = RandomUtil.getJudgeSymbols();
            String judge4 = RandomUtil.getJudgeSymbols();
            String judge5 = RandomUtil.getJudgeSymbols();

            String calculation = RandomUtil.getCalculationSymbols();
            String calculation2 = RandomUtil.getCalculationSymbols();
            String calculation3 = RandomUtil.getCalculationSymbols();
            String calculation4 = RandomUtil.getCalculationSymbols();
            String calculation5 = RandomUtil.getCalculationSymbols();
            String calculation6 = RandomUtil.getCalculationSymbols();
            String calculation7 = RandomUtil.getCalculationSymbols();
            String calculation8 = RandomUtil.getCalculationSymbols();
            String calculation9 = RandomUtil.getCalculationSymbols();

            String method = modifier + " int[] " + name + "(int pageNo, int totalPage, int displayCount) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        boolean isEven = (displayCount & "+i1+") "+judge1+" "+i2+";\n" +
                    "        int left = displayCount >> "+i3+";\n" +
                    "        int right = displayCount >> "+i4+";\n" +
                    "        int length = displayCount;\n" +
                    "        if (isEven) {\n" +
                    "            right++;\n" +
                    "        }\n" +
                    "        if (totalPage "+judge2+" displayCount) {\n" +
                    "            length = totalPage;\n" +
                    "        }\n" +
                    "        int[] result = new int[length];\n" +
                    "        if (totalPage "+judge3+" displayCount) {\n" +
                    "            if (pageNo "+judge4+" left) {\n" +
                    "                for (int i = 0; i < result.length; i++) {\n" +
                    "                    result[i] = i "+calculation+" 1;\n" +
                    "                }\n" +
                    "            } else if (pageNo "+judge5+" totalPage "+calculation9+" right) {\n" +
                    "                for (int i = 0; i < result.length; i++) {\n" +
                    "                    result[i] = i "+calculation2+" totalPage "+calculation3+" displayCount "+calculation8+" "+i5+";\n" +
                    "                }\n" +
                    "            } else {\n" +
                    "                for (int i = 0; i < result.length; i++) {\n" +
                    "                    result[i] = i "+calculation4+" pageNo "+calculation5+" left "+calculation6+" (isEven ? "+i6+" : "+i7+");\n" +
                    "                }\n" +
                    "            }\n" +
                    "        } else {\n" +
                    "            for (int i = 0; i < result.length; i++) {\n" +
                    "                result[i] = i "+calculation7+" 1;\n" +
                    "            }\n" +
                    "        }\n" +
                    "        return result;" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    int ii1 = RandomUtil.getRandom().nextInt(10) + 1;
                    int ii2 = RandomUtil.getRandom().nextInt(3) + 1;
                    int ii3 = RandomUtil.getRandom().nextInt(3) + 1;
                    return name + "(" + ii1 + ", "+ii2+", "+ii3+");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static int[] template(int pageNo, int totalPage, int displayCount) {
        boolean isEven = (displayCount & 1) == 0;
        int left = displayCount >> 1;
        int right = displayCount >> 1;
        int length = displayCount;
        if (isEven) {
            right++;
        }
        if (totalPage < displayCount) {
            length = totalPage;
        }
        int[] result = new int[length];
        if (totalPage >= displayCount) {
            if (pageNo <= left) {
                for (int i = 0; i < result.length; i++) {
                    result[i] = i + 1;
                }
            } else if (pageNo > totalPage - right) {
                for (int i = 0; i < result.length; i++) {
                    result[i] = i + totalPage - displayCount + 1;
                }
            } else {
                for (int i = 0; i < result.length; i++) {
                    result[i] = i + pageNo - left + (isEven ? 1 : 0);
                }
            }
        } else {
            for (int i = 0; i < result.length; i++) {
                result[i] = i + 1;
            }
        }
        return result;
    }
}
