package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode58 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(10);
            int i2 = RandomUtil.getRandom().nextInt(12188)+100;
            int i3 = RandomUtil.getRandom().nextInt(65281)+100;
            int i4 = RandomUtil.getRandom().nextInt(65274)+100;
            int i5 = RandomUtil.getRandom().nextInt(65148)+100;

            String abcNumber1 = RandomUtil.getAbcNumber();

            String judge1 = RandomUtil.getJudgeSymbols();
            String judge2 = RandomUtil.getJudgeSymbols();
            String judge3 = RandomUtil.getJudgeSymbols();
            String judge4 = RandomUtil.getJudgeSymbols();

            String calculation = RandomUtil.getCalculationSymbols();

            String logic = RandomUtil.getLogicSymbols();

            String method = modifier + " String " + name + "(String str) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "     if (str.length() "+judge1+" "+i1+")\n" +
                    "            return str;\n" +
                    "        char[] chars = str.toCharArray();\n" +
                    "        for (int i = 0, len = chars.length; i < len; i++) {\n" +
                    "            if (chars[i] "+judge2+" "+i2+") {\n" +
                    "                chars[i] = '"+abcNumber1+"';\n" +
                    "            } else if ("+i3+" "+judge3+" chars[i] "+logic+" chars[i] "+judge4+" "+i4+") {\n" +
                    "                chars[i] = (char) (chars[i] "+calculation+" "+i5+");\n" +
                    "            } else {\n" +
                    "                chars[i] = chars[i];\n" +
                    "            }\n" +
                    "        }\n" +
                    "        return new String(chars);" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    String i = RandomUtil.getString();
                    return name + "(\"" + i + "\");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static String template(String str) {
        if (str.length() < 10)
            return str;
        char[] chars = str.toCharArray();
        for (int i = 0, len = chars.length; i < len; i++) {
            if (chars[i] == 12288) {
                chars[i] = ' ';
            } else if (65281 <= chars[i] && chars[i] <= 65374) {
                chars[i] = (char) (chars[i] - 65248);
            } else {
                chars[i] = chars[i];
            }
        }
        return new String(chars);
    }
}
