package com.plugins.junk.method.insert.code2;

import com.plugins.junk.method.insert.InsertMethodBean;
import com.plugins.junk.method.insert.InsertMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.RandomUtil;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;

public class TemplateCode56 implements InsertMethodCode {

    @Override
    public String getCode(ClassPool classPool, CtClass ctClass, CtMethod ctMethod, boolean isAddCtField, boolean isStatic) {
        int i1 = RandomUtil.getRandom().nextInt(2) + 1;
        int i2 = RandomUtil.getRandom().nextInt(10) + 1;
        float f1 = RandomUtil.getRandom().nextFloat();
        float f2 = RandomUtil.getRandom().nextFloat();
        String calculation = RandomUtil.getCalculationSymbols();

        InsertMethodBean bean =  JavassistUtils.addCtField(ctClass, "float[]", isAddCtField, isStatic);

        String code = JavassistUtils.insertLog(this.getClass()) +"  int numDims = "+i1+";\n" +
                "        "+bean.getTypeName()+" = new float[numDims];\n" +
                "        float[] initDimensions = new float[numDims * 2];\n" +
                "        for (int i = 0; i < numDims; i++) {\n" +
                "            "+bean.getName()+"[i] = "+f1+";\n" +
                "            initDimensions[i] = -"+i2+".0f "+calculation+" "+f2+";\n" +
                "        }\n" +
                "        System.arraycopy("+bean.getName()+", 0, initDimensions, "+bean.getName()+".length , "+bean.getName()+".length);";
        return code;
    }

    private void template() {
        int numDims = 5;
        float[] initCoords = new float[numDims];
        float[] initDimensions = new float[numDims * 2];
        for (int i = 0; i < numDims; i++) {
            initCoords[i] = (float) Math.nextDown(Float.MAX_VALUE);
            initDimensions[i] = -2.0f * (float) Math.sqrt(Float.MAX_VALUE);
        }
        System.arraycopy(initCoords, 0, initDimensions, initCoords.length, initCoords.length);
    }

}
