package com.plugins.junk.utils;

import com.plugins.junk.method.insert.InsertMethodBean;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;

public class JavassistUtils {
    private final static boolean mIsInsertLog = false;

    /**
     * 随机方法内部插入代码
     *
     * @param ctMethod 方法对象
     * @param code     插入代码
     * @throws CannotCompileException 异常
     */
    public static void insertAt(CtMethod ctMethod, String code) throws CannotCompileException {
        try {
            ctMethod.insertAt(RandomUtil.getMethodLine(ctMethod), code);
        } catch (CannotCompileException e) {
//            insertAt可能报错，如果报错再随机方法头部或尾部再插一次
            if (RandomUtil.getRandom().nextBoolean())
                ctMethod.insertAfter(code);
            else
                ctMethod.insertBefore(code);
        }

    }

    /**
     * 添加变量
     *
     * @param ctClass   类对象
     * @param fieldType 变量类型
     * @param isStatic  是否静态
     * @return
     */
    public static InsertMethodBean addCtField(CtClass ctClass, String fieldType, boolean isAdd, boolean isStatic) {
        InsertMethodBean bean = new InsertMethodBean(RandomUtil.getName());
        if (isAdd) {
            try {
                CtField ctField = CtField.make(RandomUtil.getFieldModifier(isStatic) + " " + fieldType + " " + bean.getName() + ";", ctClass);
                ctClass.addField(ctField);
            } catch (CannotCompileException e) {
                LogUtil.error("[create field failed]: %s", e.getMessage());
                bean.setType(fieldType);
            }
        } else {
            bean.setType(fieldType);
        }
        return bean;
    }

    public static String insertLog(Class<?> cls) {
        if (mIsInsertLog) {
            String name = cls.getName();
            return "System.out.println(\"insertCode name:\"+\"" + name + "\");";
        }
        return "";
    }
}
