/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.util.Objects;

class Artifact {
    final String groupId;
    final String artifactId;
    final String version;

    Artifact(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    static Artifact parse(String id) {
        String[] parts = id.split(":");
        if (parts.length == 3) {
            return new Artifact(parts[0], parts[1], parts[2]);
        }
        if (parts.length == 5) {
            return new Artifact(parts[0], parts[1], parts[3]);
        }
        throw new IllegalArgumentException(id + " is not properly formatted artifact");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return Objects.equals(this.groupId, artifact.groupId) && Objects.equals(this.artifactId, artifact.artifactId) && Objects.equals(this.version, artifact.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    public String toString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }
}

