/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.javacs.FileStore;

class Cache<K, V> {
    private final Map<Key, Value> map = new HashMap<Key, Value>();

    Cache() {
    }

    boolean has(Path file, K k) {
        return !this.needs(file, k);
    }

    boolean needs(Path file, K k) {
        Key<K> key = new Key<K>(file, k);
        if (!this.map.containsKey(key)) {
            return true;
        }
        Value value = this.map.get(key);
        Instant modified = FileStore.modified(file);
        return value.created.isBefore(modified);
    }

    void load(Path file, K k, V v) {
        Key<K> key = new Key<K>(file, k);
        Value value = new Value(v);
        this.map.put(key, value);
    }

    V get(Path file, K k) {
        Key<K> key = new Key<K>(file, k);
        if (!this.map.containsKey(key)) {
            throw new IllegalArgumentException(String.valueOf(k) + " is not in map " + String.valueOf(this.map));
        }
        return this.map.get(key).value;
    }

    private static class Key<K> {
        final Path file;
        final K key;

        Key(Path file, K key) {
            this.file = file;
            this.key = key;
        }

        public boolean equals(Object other) {
            if (other.getClass() != Key.class) {
                return false;
            }
            Key that = (Key)other;
            return Objects.equals(this.key, that.key) && Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.key);
        }
    }

    private class Value {
        final V value;
        final Instant created = Instant.now();

        Value(V value) {
            this.value = value;
        }
    }
}

