/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Name;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.javacs.FileStore;
import org.javacs.JavaCompilerService;
import org.javacs.Parser;
import org.javacs.ReusableCompiler;

class CompileBatch
implements AutoCloseable {
    static final int MAX_COMPLETION_ITEMS = 50;
    final JavaCompilerService parent;
    final ReusableCompiler.Borrow borrow;
    boolean closed;
    final JavacTask task;
    final Trees trees;
    final Elements elements;
    final Types types;
    final List<CompilationUnitTree> roots;
    private static final Path FILE_NOT_FOUND = Paths.get("", new String[0]);

    CompileBatch(JavaCompilerService parent, Collection<? extends JavaFileObject> files) {
        this.parent = parent;
        this.borrow = CompileBatch.batchTask(parent, files);
        this.task = this.borrow.task;
        this.trees = Trees.instance(this.borrow.task);
        this.elements = this.borrow.task.getElements();
        this.types = this.borrow.task.getTypes();
        this.roots = new ArrayList<CompilationUnitTree>();
        try {
            for (CompilationUnitTree compilationUnitTree : this.borrow.task.parse()) {
                this.roots.add(compilationUnitTree);
            }
            this.borrow.task.analyze();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Set<Path> needsAdditionalSources() {
        HashSet<Path> addFiles = new HashSet<Path>();
        for (Diagnostic<? extends JavaFileObject> err : this.parent.diags) {
            if (!err.getCode().equals("compiler.err.cant.resolve.location") || !this.isValidFileRange(err)) continue;
            String className = this.errorText(err);
            String packageName = this.packageName(err);
            Path location = this.findPackagePrivateClass(packageName, className);
            if (location == FILE_NOT_FOUND) continue;
            addFiles.add(location);
        }
        return addFiles;
    }

    private String errorText(Diagnostic<? extends JavaFileObject> err) {
        Path file = Paths.get(err.getSource().toUri());
        String contents = FileStore.contents(file);
        int begin = (int)err.getStartPosition();
        int end = (int)err.getEndPosition();
        return contents.substring(begin, end);
    }

    private String packageName(Diagnostic<? extends JavaFileObject> err) {
        Path file = Paths.get(err.getSource().toUri());
        return FileStore.packageName(file);
    }

    private Path findPackagePrivateClass(String packageName, String className) {
        for (Path file : FileStore.list(packageName)) {
            Parser parse = Parser.parseFile(file);
            for (Name candidate : parse.packagePrivateClasses()) {
                if (!candidate.contentEquals(className)) continue;
                return file;
            }
        }
        return FILE_NOT_FOUND;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private static ReusableCompiler.Borrow batchTask(JavaCompilerService parent, Collection<? extends JavaFileObject> sources) {
        parent.diags.clear();
        List<String> options = CompileBatch.options(parent.classPath, parent.addExports);
        return parent.compiler.getTask(parent.fileManager, parent.diags::add, options, List.of(), sources);
    }

    private static String joinPath(Collection<Path> classOrSourcePath) {
        return classOrSourcePath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
    }

    private static List<String> options(Set<Path> classPath, Set<String> addExports) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, "-classpath", CompileBatch.joinPath(classPath));
        Collections.addAll(list, "--add-modules", "ALL-MODULE-PATH");
        Collections.addAll(list, "-proc:none");
        Collections.addAll(list, "-g");
        Collections.addAll(list, "-Xlint:cast", "-Xlint:deprecation", "-Xlint:empty", "-Xlint:fallthrough", "-Xlint:finally", "-Xlint:path", "-Xlint:unchecked", "-Xlint:varargs", "-Xlint:static");
        for (String export : addExports) {
            list.add("--add-exports");
            list.add(export + "=ALL-UNNAMED");
        }
        return list;
    }

    private boolean isValidFileRange(Diagnostic<? extends JavaFileObject> d) {
        return d.getSource().toUri().getScheme().equals("file") && d.getStartPosition() >= 0L && d.getEndPosition() >= 0L;
    }
}

