/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import javax.tools.StandardLocation;
import org.javacs.JavaHomeHelper;
import org.javacs.SourceFileManager;

public class Docs {
    final SourceFileManager fileManager = new SourceFileManager();
    private static final Path NOT_FOUND = Paths.get("", new String[0]);
    private static Path cacheSrcZip;
    private static final Logger LOG;

    Docs(Set<Path> docPath) {
        Path srcZipPath = Docs.srcZip();
        ArrayList<Path> sourcePath = new ArrayList<Path>(docPath);
        if (srcZipPath != NOT_FOUND) {
            sourcePath.add(srcZipPath);
        }
        try {
            this.fileManager.setLocationFromPaths(StandardLocation.SOURCE_PATH, sourcePath);
            if (srcZipPath != NOT_FOUND) {
                this.fileManager.setLocationFromPaths(StandardLocation.MODULE_SOURCE_PATH, Set.of(srcZipPath));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path srcZip() {
        if (cacheSrcZip == null) {
            cacheSrcZip = Docs.findSrcZip();
        }
        if (cacheSrcZip == NOT_FOUND) {
            return NOT_FOUND;
        }
        try {
            FileSystem fs = FileSystems.newFileSystem(cacheSrcZip, Docs.class.getClassLoader());
            return fs.getPath("/", new String[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path findSrcZip() {
        String[] locations;
        Path javaHome = JavaHomeHelper.javaHome();
        for (String rel : locations = new String[]{"lib/src.zip", "src.zip"}) {
            Path abs = javaHome.resolve(rel);
            if (!Files.exists(abs, new LinkOption[0])) continue;
            LOG.info("Found " + String.valueOf(abs));
            return abs;
        }
        LOG.warning("Couldn't find src.zip in " + String.valueOf(javaHome));
        return NOT_FOUND;
    }

    static {
        LOG = Logger.getLogger("main");
    }
}

