/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javacs.Artifact;

class InferConfig {
    private static final Logger LOG = Logger.getLogger("main");
    private final Path workspaceRoot;
    private final Collection<String> externalDependencies;
    private final Path mavenHome;
    private final Path gradleHome;
    private static final Pattern DEPENDENCY = Pattern.compile("^\\[INFO\\]\\s+(.*:.*:.*:.*:.*):(/.*?)( -- module .*)?$");
    private static final Path NOT_FOUND = Paths.get("", new String[0]);

    InferConfig(Path workspaceRoot, Collection<String> externalDependencies, Path mavenHome, Path gradleHome) {
        this.workspaceRoot = workspaceRoot;
        this.externalDependencies = externalDependencies;
        this.mavenHome = mavenHome;
        this.gradleHome = gradleHome;
    }

    InferConfig(Path workspaceRoot, Collection<String> externalDependencies) {
        this(workspaceRoot, externalDependencies, InferConfig.defaultMavenHome(), InferConfig.defaultGradleHome());
    }

    InferConfig(Path workspaceRoot) {
        this(workspaceRoot, Collections.emptySet(), InferConfig.defaultMavenHome(), InferConfig.defaultGradleHome());
    }

    private static Path defaultMavenHome() {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2");
    }

    private static Path defaultGradleHome() {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(".gradle");
    }

    Set<Path> classPath() {
        if (!this.externalDependencies.isEmpty()) {
            HashSet<Path> result = new HashSet<Path>();
            for (String id : this.externalDependencies) {
                Artifact a = Artifact.parse(id);
                Path found = this.findAnyJar(a, false);
                if (found == NOT_FOUND) {
                    LOG.warning(String.format("Couldn't find jar for %s in %s or %s", a, this.mavenHome, this.gradleHome));
                    continue;
                }
                result.add(found);
            }
            return result;
        }
        Path pomXml = this.workspaceRoot.resolve("pom.xml");
        if (Files.exists(pomXml, new LinkOption[0])) {
            return InferConfig.mvnDependencies(pomXml, "dependency:list");
        }
        return Collections.emptySet();
    }

    Set<Path> buildDocPath() {
        if (!this.externalDependencies.isEmpty()) {
            HashSet<Path> result = new HashSet<Path>();
            for (String id : this.externalDependencies) {
                Artifact a = Artifact.parse(id);
                Path found = this.findAnyJar(a, true);
                if (found == NOT_FOUND) {
                    LOG.warning(String.format("Couldn't find doc jar for %s in %s or %s", a, this.mavenHome, this.gradleHome));
                    continue;
                }
                result.add(found);
            }
            return result;
        }
        Path pomXml = this.workspaceRoot.resolve("pom.xml");
        if (Files.exists(pomXml, new LinkOption[0])) {
            return InferConfig.mvnDependencies(pomXml, "dependency:sources");
        }
        return Collections.emptySet();
    }

    private Path findAnyJar(Artifact artifact, boolean source) {
        Path maven = this.findMavenJar(artifact, source);
        return maven;
    }

    Path findMavenJar(Artifact artifact, boolean source) {
        Path jar = this.mavenHome.resolve("repository").resolve(artifact.groupId.replace('.', File.separatorChar)).resolve(artifact.artifactId).resolve(artifact.version).resolve(this.fileName(artifact, source));
        if (!Files.exists(jar, new LinkOption[0])) {
            LOG.warning(String.valueOf(jar) + " does not exist");
            return NOT_FOUND;
        }
        return jar;
    }

    private String fileName(Artifact artifact, boolean source) {
        return artifact.artifactId + "-" + artifact.version + (source ? "-sources" : "") + ".jar";
    }

    static Set<Path> mvnDependencies(Path pomXml, String goal) {
        Objects.requireNonNull(pomXml, "pom.xml path is null");
        try {
            CharSequence[] command = new String[]{InferConfig.getMvnCommand(), "--batch-mode", "validate", goal, "-DincludeScope=test", "-DoutputAbsoluteArtifactFilename=true"};
            Path output = Files.createTempFile("java-language-server-maven-output", ".txt", new FileAttribute[0]);
            LOG.info("Running " + String.join((CharSequence)" ", command) + " ...");
            File workingDirectory = pomXml.toAbsolutePath().getParent().toFile();
            Process process = new ProcessBuilder(new String[0]).command((String[])command).directory(workingDirectory).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(output.toFile()).start();
            int result = process.waitFor();
            if (result != 0) {
                LOG.severe("`" + String.join((CharSequence)" ", command) + "` returned " + result);
                return Set.of();
            }
            HashSet<Path> dependencies = new HashSet<Path>();
            for (String line : Files.readAllLines(output)) {
                Path jar = InferConfig.readDependency(line);
                if (jar == NOT_FOUND) continue;
                dependencies.add(jar);
            }
            return dependencies;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static Path readDependency(String line) {
        Matcher match = DEPENDENCY.matcher(line);
        if (!match.matches()) {
            return NOT_FOUND;
        }
        String artifact = match.group(1);
        String path = match.group(2);
        LOG.info(String.format("...%s => %s", artifact, path));
        return Paths.get(path, new String[0]);
    }

    static String getMvnCommand() {
        String mvnCommand = "mvn";
        if (File.separatorChar == '\\' && (mvnCommand = InferConfig.findExecutableOnPath("mvn.cmd")) == null) {
            mvnCommand = InferConfig.findExecutableOnPath("mvn.bat");
        }
        return mvnCommand;
    }

    private static String findExecutableOnPath(String name) {
        for (String dirname : System.getenv("PATH").split(File.pathSeparator)) {
            File file = new File(dirname, name);
            if (!file.isFile() || !file.canExecute()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }
}

