/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.sun.source.tree.CompilationUnitTree;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.javacs.Cache;
import org.javacs.CompileBatch;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.Docs;
import org.javacs.FileStore;
import org.javacs.FindTypeDeclarations;
import org.javacs.ParseTask;
import org.javacs.Parser;
import org.javacs.ReusableCompiler;
import org.javacs.ScanClassPath;
import org.javacs.SourceFileManager;
import org.javacs.SourceFileObject;
import org.javacs.StringSearch;

class JavaCompilerService
implements CompilerProvider {
    final Set<Path> classPath;
    final Set<Path> docPath;
    final Set<String> addExports;
    final ReusableCompiler compiler = new ReusableCompiler();
    final Docs docs;
    final Set<String> jdkClasses = ScanClassPath.jdkTopLevelClasses();
    final Set<String> classPathClasses;
    final List<Diagnostic<? extends JavaFileObject>> diags = new ArrayList<Diagnostic<? extends JavaFileObject>>();
    final SourceFileManager fileManager;
    private CompileBatch cachedCompile;
    private Map<JavaFileObject, Long> cachedModified = new HashMap<JavaFileObject, Long>();
    private static final Pattern PACKAGE_EXTRACTOR = Pattern.compile("^([a-z][_a-zA-Z0-9]*\\.)*[a-z][_a-zA-Z0-9]*");
    private static final Pattern SIMPLE_EXTRACTOR = Pattern.compile("[A-Z][_a-zA-Z0-9]*$");
    private static final Cache<String, Boolean> cacheContainsWord = new Cache();
    private static final Cache<Void, List<String>> cacheContainsType = new Cache();
    private Cache<Void, List<String>> cacheFileImports = new Cache();
    private static final Logger LOG = Logger.getLogger("main");

    JavaCompilerService(Set<Path> classPath, Set<Path> docPath, Set<String> addExports) {
        System.err.println("Class path:");
        for (Path p : classPath) {
            System.err.println("  " + String.valueOf(p));
        }
        System.err.println("Doc path:");
        for (Path p : docPath) {
            System.err.println("  " + String.valueOf(p));
        }
        this.classPath = Collections.unmodifiableSet(classPath);
        this.docPath = Collections.unmodifiableSet(docPath);
        this.addExports = Collections.unmodifiableSet(addExports);
        this.docs = new Docs(docPath);
        this.classPathClasses = ScanClassPath.classPathTopLevelClasses(classPath);
        this.fileManager = new SourceFileManager();
    }

    private boolean needsCompile(Collection<? extends JavaFileObject> sources) {
        if (this.cachedModified.size() != sources.size()) {
            return true;
        }
        for (JavaFileObject javaFileObject : sources) {
            if (!this.cachedModified.containsKey(javaFileObject)) {
                return true;
            }
            if (javaFileObject.getLastModified() == this.cachedModified.get(javaFileObject).longValue()) continue;
            return true;
        }
        return false;
    }

    private void loadCompile(Collection<? extends JavaFileObject> sources) {
        if (this.cachedCompile != null) {
            if (!this.cachedCompile.closed) {
                throw new RuntimeException("Compiler is still in-use!");
            }
            this.cachedCompile.borrow.close();
        }
        this.cachedCompile = this.doCompile(sources);
        this.cachedModified.clear();
        for (JavaFileObject javaFileObject : sources) {
            this.cachedModified.put(javaFileObject, javaFileObject.getLastModified());
        }
    }

    private CompileBatch doCompile(Collection<? extends JavaFileObject> sources) {
        if (sources.isEmpty()) {
            throw new RuntimeException("empty sources");
        }
        CompileBatch firstAttempt = new CompileBatch(this, sources);
        Set<Path> addFiles = firstAttempt.needsAdditionalSources();
        if (addFiles.isEmpty()) {
            return firstAttempt;
        }
        LOG.info("...need to recompile with " + String.valueOf(addFiles));
        firstAttempt.close();
        firstAttempt.borrow.close();
        ArrayList<? extends JavaFileObject> moreSources = new ArrayList<JavaFileObject>();
        moreSources.addAll(sources);
        for (Path add : addFiles) {
            moreSources.add(new SourceFileObject(add));
        }
        return new CompileBatch(this, moreSources);
    }

    private CompileBatch compileBatch(Collection<? extends JavaFileObject> sources) {
        if (this.needsCompile(sources)) {
            this.loadCompile(sources);
        } else {
            LOG.info("...using cached compile");
        }
        return this.cachedCompile;
    }

    private String packageName(String className) {
        Matcher m = PACKAGE_EXTRACTOR.matcher(className);
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    private String simpleName(String className) {
        Matcher m = SIMPLE_EXTRACTOR.matcher(className);
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    private boolean containsWord(Path file, String word) {
        if (cacheContainsWord.needs(file, word)) {
            cacheContainsWord.load(file, word, StringSearch.containsWord(file, word));
        }
        return cacheContainsWord.get(file, word);
    }

    private boolean containsType(Path file, String className) {
        if (cacheContainsType.needs(file, null)) {
            CompilationUnitTree root = this.parse((Path)file).root;
            ArrayList types = new ArrayList();
            new FindTypeDeclarations().scan(root, types);
            cacheContainsType.load(file, null, types);
        }
        return cacheContainsType.get(file, null).contains(className);
    }

    private List<String> readImports(Path file) {
        if (this.cacheFileImports.needs(file, null)) {
            this.loadImports(file);
        }
        return this.cacheFileImports.get(file, null);
    }

    private void loadImports(Path file) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern importClass = Pattern.compile("^import +([\\w\\.]+\\.\\w+);");
        Pattern importStar = Pattern.compile("^import +([\\w\\.]+\\.\\*);");
        try (BufferedReader lines = FileStore.lines(file);){
            String line = lines.readLine();
            while (line != null) {
                Matcher matchesStar;
                if (line.contains("class")) {
                    break;
                }
                Matcher matchesClass = importClass.matcher(line);
                if (matchesClass.matches()) {
                    list.add(matchesClass.group(1));
                }
                if ((matchesStar = importStar.matcher(line)).matches()) {
                    list.add(matchesStar.group(1));
                }
                line = lines.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cacheFileImports.load(file, null, list);
    }

    @Override
    public Set<String> imports() {
        HashSet<String> all = new HashSet<String>();
        for (Path f : FileStore.all()) {
            all.addAll(this.readImports(f));
        }
        return all;
    }

    @Override
    public List<String> publicTopLevelTypes() {
        ArrayList<String> all = new ArrayList<String>();
        for (Path file : FileStore.all()) {
            String fileName = file.getFileName().toString();
            if (!fileName.endsWith(".java")) continue;
            Object className = fileName.substring(0, fileName.length() - ".java".length());
            String packageName = FileStore.packageName(file);
            if (!packageName.isEmpty()) {
                className = packageName + "." + (String)className;
            }
            all.add((String)className);
        }
        all.addAll(this.classPathClasses);
        all.addAll(this.jdkClasses);
        return all;
    }

    @Override
    public List<String> packagePrivateTopLevelTypes(String packageName) {
        return List.of("TODO");
    }

    private boolean containsImport(Path file, String className) {
        String packageName = this.packageName(className);
        if (FileStore.packageName(file).equals(packageName)) {
            return true;
        }
        String star = packageName + ".*";
        for (String i : this.readImports(file)) {
            if (!i.equals(className) && !i.equals(star)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<Path> search(String query) {
        Predicate<Path> test = f -> StringSearch.containsWordMatching(f, query);
        return () -> FileStore.all().stream().filter(test).iterator();
    }

    @Override
    public Optional<JavaFileObject> findAnywhere(String className) {
        Optional<JavaFileObject> fromDocs = this.findPublicTypeDeclarationInDocPath(className);
        if (fromDocs.isPresent()) {
            return fromDocs;
        }
        Optional<JavaFileObject> fromJdk = this.findPublicTypeDeclarationInJdk(className);
        if (fromJdk.isPresent()) {
            return fromJdk;
        }
        Path fromSource = this.findTypeDeclaration(className);
        if (fromSource != NOT_FOUND) {
            return Optional.of(new SourceFileObject(fromSource));
        }
        return Optional.empty();
    }

    private Optional<JavaFileObject> findPublicTypeDeclarationInDocPath(String className) {
        try {
            JavaFileObject found = this.docs.fileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, className, JavaFileObject.Kind.SOURCE);
            return Optional.ofNullable(found);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<JavaFileObject> findPublicTypeDeclarationInJdk(String className) {
        try {
            for (String module : ScanClassPath.JDK_MODULES) {
                JavaFileObject fromModuleSourcePath;
                JavaFileManager.Location moduleLocation = this.docs.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.MODULE_SOURCE_PATH, module);
                if (moduleLocation == null || (fromModuleSourcePath = this.docs.fileManager.getJavaFileForInput(moduleLocation, className, JavaFileObject.Kind.SOURCE)) == null) continue;
                LOG.info(String.format("...found %s in module %s of jdk", fromModuleSourcePath.toUri(), module));
                return Optional.of(fromModuleSourcePath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Optional.empty();
    }

    @Override
    public Path findTypeDeclaration(String className) {
        Path fastFind = this.findPublicTypeDeclaration(className);
        if (fastFind != NOT_FOUND) {
            return fastFind;
        }
        String packageName = this.packageName(className);
        String simpleName = this.simpleName(className);
        for (Path f : FileStore.list(packageName)) {
            if (!this.containsWord(f, simpleName) || !this.containsType(f, className)) continue;
            return f;
        }
        return NOT_FOUND;
    }

    private Path findPublicTypeDeclaration(String className) {
        JavaFileObject source;
        try {
            source = this.fileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, className, JavaFileObject.Kind.SOURCE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (source == null) {
            return NOT_FOUND;
        }
        if (!source.toUri().getScheme().equals("file")) {
            return NOT_FOUND;
        }
        Path file = Paths.get(source.toUri());
        if (!this.containsType(file, className)) {
            return NOT_FOUND;
        }
        return file;
    }

    @Override
    public Path[] findTypeReferences(String className) {
        String packageName = this.packageName(className);
        String simpleName = this.simpleName(className);
        ArrayList<Path> candidates = new ArrayList<Path>();
        for (Path f : FileStore.all()) {
            if (!this.containsWord(f, packageName) || !this.containsImport(f, className) || !this.containsWord(f, simpleName)) continue;
            candidates.add(f);
        }
        return (Path[])candidates.toArray(Path[]::new);
    }

    @Override
    public Path[] findMemberReferences(String className, String memberName) {
        ArrayList<Path> candidates = new ArrayList<Path>();
        for (Path f : FileStore.all()) {
            if (!this.containsWord(f, memberName)) continue;
            candidates.add(f);
        }
        return (Path[])candidates.toArray(Path[]::new);
    }

    @Override
    public ParseTask parse(Path file) {
        Parser parser = Parser.parseFile(file);
        return new ParseTask(parser.task, parser.root);
    }

    @Override
    public ParseTask parse(JavaFileObject file) {
        Parser parser = Parser.parseJavaFileObject(file);
        return new ParseTask(parser.task, parser.root);
    }

    @Override
    public CompileTask compile(Path ... files) {
        ArrayList<SourceFileObject> sources = new ArrayList<SourceFileObject>();
        for (Path f : files) {
            sources.add(new SourceFileObject(f));
        }
        return this.compile(sources);
    }

    @Override
    public CompileTask compile(Collection<? extends JavaFileObject> sources) {
        CompileBatch compile = this.compileBatch(sources);
        return new CompileTask(compile.task, compile.roots, this.diags, compile::close);
    }
}

