/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.sun.source.tree.LineMap;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.FileStore;
import org.javacs.FindHelper;
import org.javacs.FindNameAt;
import org.javacs.InferConfig;
import org.javacs.JavaCompilerService;
import org.javacs.JsonHelper;
import org.javacs.ParseTask;
import org.javacs.action.CodeActionProvider;
import org.javacs.completion.CompletionProvider;
import org.javacs.completion.SignatureProvider;
import org.javacs.fold.FoldProvider;
import org.javacs.hover.HoverProvider;
import org.javacs.index.SymbolProvider;
import org.javacs.lens.CodeLensProvider;
import org.javacs.lsp.CodeAction;
import org.javacs.lsp.CodeActionParams;
import org.javacs.lsp.CodeLens;
import org.javacs.lsp.CodeLensParams;
import org.javacs.lsp.CompletionItem;
import org.javacs.lsp.CompletionList;
import org.javacs.lsp.DidChangeConfigurationParams;
import org.javacs.lsp.DidChangeTextDocumentParams;
import org.javacs.lsp.DidChangeWatchedFilesParams;
import org.javacs.lsp.DidCloseTextDocumentParams;
import org.javacs.lsp.DidOpenTextDocumentParams;
import org.javacs.lsp.DidSaveTextDocumentParams;
import org.javacs.lsp.DocumentFormattingParams;
import org.javacs.lsp.DocumentSymbolParams;
import org.javacs.lsp.FileEvent;
import org.javacs.lsp.FoldingRange;
import org.javacs.lsp.FoldingRangeParams;
import org.javacs.lsp.Hover;
import org.javacs.lsp.InitializeParams;
import org.javacs.lsp.InitializeResult;
import org.javacs.lsp.JavaReportProgressParams;
import org.javacs.lsp.JavaStartProgressParams;
import org.javacs.lsp.LanguageClient;
import org.javacs.lsp.LanguageServer;
import org.javacs.lsp.Location;
import org.javacs.lsp.MarkedString;
import org.javacs.lsp.PublishDiagnosticsParams;
import org.javacs.lsp.ReferenceParams;
import org.javacs.lsp.RenameParams;
import org.javacs.lsp.RenameResponse;
import org.javacs.lsp.SignatureHelp;
import org.javacs.lsp.SymbolInformation;
import org.javacs.lsp.TextDocumentPositionParams;
import org.javacs.lsp.TextEdit;
import org.javacs.lsp.WorkspaceEdit;
import org.javacs.lsp.WorkspaceSymbolParams;
import org.javacs.markup.ErrorProvider;
import org.javacs.navigation.DefinitionProvider;
import org.javacs.navigation.ReferenceProvider;
import org.javacs.rewrite.AutoAddOverrides;
import org.javacs.rewrite.AutoFixImports;
import org.javacs.rewrite.RenameField;
import org.javacs.rewrite.RenameMethod;
import org.javacs.rewrite.RenameVariable;
import org.javacs.rewrite.Rewrite;

public class JavaLanguageServer
extends LanguageServer {
    private Path workspaceRoot;
    private final LanguageClient client;
    private JavaCompilerService cacheCompiler;
    private JsonObject cacheSettings;
    private JsonObject settings = new JsonObject();
    private boolean modifiedBuild = true;
    private static final String[] watchFiles = new String[]{"**/*.java", "**/pom.xml", "**/BUILD"};
    private boolean uncheckedChanges = false;
    private Path lastEdited = Paths.get("", new String[0]);
    private static final Logger LOG = Logger.getLogger("main");

    JavaCompilerService compiler() {
        if (this.needsCompiler()) {
            this.cacheCompiler = this.createCompiler();
            this.cacheSettings = this.settings;
            this.modifiedBuild = false;
        }
        return this.cacheCompiler;
    }

    private boolean needsCompiler() {
        if (this.modifiedBuild) {
            return true;
        }
        if (!this.settings.equals((Object)this.cacheSettings)) {
            LOG.info("Settings\n\t" + String.valueOf(this.settings) + "\nis different than\n\t" + String.valueOf(this.cacheSettings));
            return true;
        }
        return false;
    }

    void lint(Collection<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        LOG.info("Lint " + files.size() + " files...");
        Instant started = Instant.now();
        try (CompileTask task = this.compiler().compile((Path[])files.toArray(Path[]::new));){
            Instant compiled = Instant.now();
            LOG.info("...compiled in " + Duration.between(started, compiled).toMillis() + " ms");
            for (PublishDiagnosticsParams errs : new ErrorProvider(task).errors()) {
                this.client.publishDiagnostics(errs);
            }
            Instant published = Instant.now();
            LOG.info("...published in " + Duration.between(started, published).toMillis() + " ms");
        }
    }

    private void javaStartProgress(JavaStartProgressParams params) {
        this.client.customNotification("java/startProgress", JsonHelper.GSON.toJsonTree((Object)params));
    }

    private void javaReportProgress(JavaReportProgressParams params) {
        this.client.customNotification("java/reportProgress", JsonHelper.GSON.toJsonTree((Object)params));
    }

    private void javaEndProgress() {
        this.client.customNotification("java/endProgress", (JsonElement)JsonNull.INSTANCE);
    }

    private JavaCompilerService createCompiler() {
        Objects.requireNonNull(this.workspaceRoot, "Can't create compiler because workspaceRoot has not been initialized");
        this.javaStartProgress(new JavaStartProgressParams("Configure javac"));
        this.javaReportProgress(new JavaReportProgressParams("Finding source roots"));
        Set<String> externalDependencies = this.externalDependencies();
        Set<Path> classPath = this.classPath();
        Set<String> addExports = this.addExports();
        if (!classPath.isEmpty()) {
            this.javaEndProgress();
            return new JavaCompilerService(classPath, this.docPath(), addExports);
        }
        InferConfig infer = new InferConfig(this.workspaceRoot, externalDependencies);
        this.javaReportProgress(new JavaReportProgressParams("Inferring class path"));
        classPath = infer.classPath();
        this.javaReportProgress(new JavaReportProgressParams("Inferring doc path"));
        Set<Path> docPath = infer.buildDocPath();
        this.javaEndProgress();
        return new JavaCompilerService(classPath, docPath, addExports);
    }

    private Set<String> externalDependencies() {
        if (!this.settings.has("externalDependencies")) {
            return Set.of();
        }
        JsonArray array = this.settings.getAsJsonArray("externalDependencies");
        HashSet<String> strings = new HashSet<String>();
        for (JsonElement each : array) {
            strings.add(each.getAsString());
        }
        return strings;
    }

    private Set<Path> classPath() {
        if (!this.settings.has("classPath")) {
            return Set.of();
        }
        JsonArray array = this.settings.getAsJsonArray("classPath");
        HashSet<Path> paths = new HashSet<Path>();
        for (JsonElement each : array) {
            paths.add(Paths.get(each.getAsString(), new String[0]).toAbsolutePath());
        }
        return paths;
    }

    private Set<Path> docPath() {
        if (!this.settings.has("docPath")) {
            return Set.of();
        }
        JsonArray array = this.settings.getAsJsonArray("docPath");
        HashSet<Path> paths = new HashSet<Path>();
        for (JsonElement each : array) {
            paths.add(Paths.get(each.getAsString(), new String[0]).toAbsolutePath());
        }
        return paths;
    }

    private Set<String> addExports() {
        if (!this.settings.has("addExports")) {
            return Set.of();
        }
        JsonArray array = this.settings.getAsJsonArray("addExports");
        HashSet<String> strings = new HashSet<String>();
        for (JsonElement each : array) {
            strings.add(each.getAsString());
        }
        return strings;
    }

    @Override
    public InitializeResult initialize(InitializeParams params) {
        this.workspaceRoot = Paths.get(params.rootUri);
        FileStore.setWorkspaceRoots(Set.of(Paths.get(params.rootUri)));
        JsonObject c = new JsonObject();
        c.addProperty("textDocumentSync", (Number)2);
        c.addProperty("hoverProvider", Boolean.valueOf(true));
        JsonObject completionOptions = new JsonObject();
        completionOptions.addProperty("resolveProvider", Boolean.valueOf(true));
        JsonArray triggerCharacters = new JsonArray();
        triggerCharacters.add(".");
        completionOptions.add("triggerCharacters", (JsonElement)triggerCharacters);
        c.add("completionProvider", (JsonElement)completionOptions);
        JsonObject signatureHelpOptions = new JsonObject();
        JsonArray signatureTrigger = new JsonArray();
        signatureTrigger.add("(");
        signatureTrigger.add(",");
        signatureHelpOptions.add("triggerCharacters", (JsonElement)signatureTrigger);
        c.add("signatureHelpProvider", (JsonElement)signatureHelpOptions);
        c.addProperty("referencesProvider", Boolean.valueOf(true));
        c.addProperty("definitionProvider", Boolean.valueOf(true));
        c.addProperty("workspaceSymbolProvider", Boolean.valueOf(true));
        c.addProperty("documentSymbolProvider", Boolean.valueOf(true));
        c.addProperty("documentFormattingProvider", Boolean.valueOf(true));
        JsonObject codeLensOptions = new JsonObject();
        c.add("codeLensProvider", (JsonElement)codeLensOptions);
        c.addProperty("foldingRangeProvider", Boolean.valueOf(true));
        c.addProperty("codeActionProvider", Boolean.valueOf(true));
        JsonObject renameOptions = new JsonObject();
        renameOptions.addProperty("prepareProvider", Boolean.valueOf(true));
        c.add("renameProvider", (JsonElement)renameOptions);
        return new InitializeResult(c);
    }

    @Override
    public void initialized() {
        this.client.registerCapability("workspace/didChangeWatchedFiles", (JsonElement)this.watchFiles(watchFiles));
    }

    private JsonObject watchFiles(String ... globPatterns) {
        JsonObject options = new JsonObject();
        JsonArray watchers = new JsonArray();
        for (String p : globPatterns) {
            JsonObject config = new JsonObject();
            config.addProperty("globPattern", p);
            watchers.add((JsonElement)config);
        }
        options.add("watchers", (JsonElement)watchers);
        return options;
    }

    @Override
    public void shutdown() {
    }

    public JavaLanguageServer(LanguageClient client) {
        this.client = client;
    }

    @Override
    public List<SymbolInformation> workspaceSymbols(WorkspaceSymbolParams params) {
        return new SymbolProvider(this.compiler()).findSymbols(params.query, 50);
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams change) {
        JsonElement java = change.settings.getAsJsonObject().get("java");
        LOG.info("Received java settings " + String.valueOf(java));
        this.settings = java.getAsJsonObject();
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        for (FileEvent c : params.changes) {
            String name;
            Path file = Paths.get(c.uri);
            if (FileStore.isJavaFile(file)) {
                switch (c.type) {
                    case 1: {
                        FileStore.externalCreate(file);
                        break;
                    }
                    case 2: {
                        FileStore.externalChange(file);
                        break;
                    }
                    case 3: {
                        FileStore.externalDelete(file);
                    }
                }
                return;
            }
            switch (name = file.getFileName().toString()) {
                case "BUILD": 
                case "pom.xml": {
                    LOG.info("Compiler needs to be re-created because " + String.valueOf(file) + " has changed");
                    this.modifiedBuild = true;
                }
            }
        }
    }

    @Override
    public Optional<CompletionList> completion(TextDocumentPositionParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return Optional.empty();
        }
        Path file = Paths.get(params.textDocument.uri);
        CompletionProvider provider = new CompletionProvider(this.compiler());
        CompletionList list = provider.complete(file, params.position.line + 1, params.position.character + 1);
        if (list == CompletionProvider.NOT_SUPPORTED) {
            return Optional.empty();
        }
        return Optional.of(list);
    }

    @Override
    public CompletionItem resolveCompletionItem(CompletionItem unresolved) {
        new HoverProvider(this.compiler()).resolveCompletionItem(unresolved);
        return unresolved;
    }

    @Override
    public Optional<Hover> hover(TextDocumentPositionParams position) {
        URI uri = position.textDocument.uri;
        int line = position.position.line + 1;
        int column = position.position.character + 1;
        if (!FileStore.isJavaFile(uri)) {
            return Optional.empty();
        }
        Path file = Paths.get(uri);
        List<MarkedString> list = new HoverProvider(this.compiler()).hover(file, line, column);
        if (list == HoverProvider.NOT_SUPPORTED) {
            return Optional.empty();
        }
        return Optional.of(new Hover(list));
    }

    @Override
    public Optional<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return Optional.empty();
        }
        Path file = Paths.get(params.textDocument.uri);
        int line = params.position.line + 1;
        int column = params.position.character + 1;
        SignatureHelp help = new SignatureProvider(this.compiler()).signatureHelp(file, line, column);
        if (help == SignatureProvider.NOT_SUPPORTED) {
            return Optional.empty();
        }
        return Optional.of(help);
    }

    @Override
    public Optional<List<Location>> gotoDefinition(TextDocumentPositionParams position) {
        if (!FileStore.isJavaFile(position.textDocument.uri)) {
            return Optional.empty();
        }
        Path file = Paths.get(position.textDocument.uri);
        int line = position.position.line + 1;
        int column = position.position.character + 1;
        List<Location> found = new DefinitionProvider(this.compiler(), file, line, column).find();
        if (found == DefinitionProvider.NOT_SUPPORTED) {
            return Optional.empty();
        }
        return Optional.of(found);
    }

    @Override
    public Optional<List<Location>> findReferences(ReferenceParams position) {
        if (!FileStore.isJavaFile(position.textDocument.uri)) {
            return Optional.empty();
        }
        Path file = Paths.get(position.textDocument.uri);
        int line = position.position.line + 1;
        int column = position.position.character + 1;
        List<Location> found = new ReferenceProvider(this.compiler(), file, line, column).find();
        if (found == ReferenceProvider.NOT_SUPPORTED) {
            return Optional.empty();
        }
        return Optional.of(found);
    }

    @Override
    public List<SymbolInformation> documentSymbol(DocumentSymbolParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return List.of();
        }
        Path file = Paths.get(params.textDocument.uri);
        return new SymbolProvider(this.compiler()).documentSymbols(file);
    }

    @Override
    public List<CodeLens> codeLens(CodeLensParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return List.of();
        }
        Path file = Paths.get(params.textDocument.uri);
        ParseTask task = this.compiler().parse(file);
        return CodeLensProvider.find(task);
    }

    @Override
    public CodeLens resolveCodeLens(CodeLens unresolved) {
        return null;
    }

    @Override
    public List<TextEdit> formatting(DocumentFormattingParams params) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        Path file = Paths.get(params.textDocument.uri);
        TextEdit[] fixImports = new AutoFixImports(file).rewrite(this.compiler()).get(file);
        Collections.addAll(edits, fixImports);
        TextEdit[] addOverrides = new AutoAddOverrides(file).rewrite(this.compiler()).get(file);
        Collections.addAll(edits, addOverrides);
        return edits;
    }

    @Override
    public List<FoldingRange> foldingRange(FoldingRangeParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return List.of();
        }
        Path file = Paths.get(params.textDocument.uri);
        return new FoldProvider(this.compiler()).foldingRanges(file);
    }

    @Override
    public Optional<RenameResponse> prepareRename(TextDocumentPositionParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return Optional.empty();
        }
        LOG.info("Try to rename...");
        Path file = Paths.get(params.textDocument.uri);
        try (CompileTask task = this.compiler().compile(file);){
            LineMap lines = task.root().getLineMap();
            long cursor = lines.getPosition(params.position.line + 1, params.position.character + 1);
            TreePath path = (TreePath)new FindNameAt(task).scan(task.root(), Long.valueOf(cursor));
            if (path == null) {
                LOG.info("...no element under cursor");
                Optional<RenameResponse> optional = Optional.empty();
                return optional;
            }
            Element el = Trees.instance(task.task).getElement(path);
            if (el == null) {
                LOG.info("...couldn't resolve element");
                Optional<RenameResponse> optional = Optional.empty();
                return optional;
            }
            if (!this.canRename(el)) {
                LOG.info("...can't rename " + String.valueOf(el));
                Optional<RenameResponse> optional = Optional.empty();
                return optional;
            }
            if (!this.canFindSource(el)) {
                LOG.info("...can't find source for " + String.valueOf(el));
                Optional<RenameResponse> optional = Optional.empty();
                return optional;
            }
            RenameResponse response = new RenameResponse();
            response.range = FindHelper.location((CompileTask)task, (TreePath)path).range;
            response.placeholder = el.getSimpleName().toString();
            Optional<RenameResponse> optional = Optional.of(response);
            return optional;
        }
    }

    private boolean canRename(Element rename) {
        switch (rename.getKind()) {
            case METHOD: 
            case FIELD: 
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case EXCEPTION_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    private boolean canFindSource(Element rename) {
        if (rename == null) {
            return false;
        }
        if (rename instanceof TypeElement) {
            TypeElement type = (TypeElement)rename;
            String name = type.getQualifiedName().toString();
            return this.compiler().findTypeDeclaration(name) != CompilerProvider.NOT_FOUND;
        }
        return this.canFindSource(rename.getEnclosingElement());
    }

    @Override
    public WorkspaceEdit rename(RenameParams params) {
        Rewrite rw = this.createRewrite(params);
        WorkspaceEdit response = new WorkspaceEdit();
        Map<Path, TextEdit[]> map = rw.rewrite(this.compiler());
        for (Path editedFile : map.keySet()) {
            response.changes.put(editedFile.toUri(), List.of(map.get(editedFile)));
        }
        return response;
    }

    private Rewrite createRewrite(RenameParams params) {
        Path file = Paths.get(params.textDocument.uri);
        try (CompileTask task = this.compiler().compile(file);){
            LineMap lines = task.root().getLineMap();
            long position = lines.getPosition(params.position.line + 1, params.position.character + 1);
            TreePath path = (TreePath)new FindNameAt(task).scan(task.root(), Long.valueOf(position));
            if (path == null) {
                Rewrite rewrite = Rewrite.NOT_SUPPORTED;
                return rewrite;
            }
            Element el = Trees.instance(task.task).getElement(path);
            switch (el.getKind()) {
                case METHOD: {
                    RenameMethod renameMethod = this.renameMethod(task, (ExecutableElement)el, params.newName);
                    return renameMethod;
                }
                case FIELD: {
                    RenameField renameField = this.renameField(task, (VariableElement)el, params.newName);
                    return renameField;
                }
                case LOCAL_VARIABLE: 
                case PARAMETER: 
                case EXCEPTION_PARAMETER: {
                    RenameVariable renameVariable = this.renameVariable(task, (VariableElement)el, params.newName);
                    return renameVariable;
                }
            }
            Rewrite rewrite = Rewrite.NOT_SUPPORTED;
            return rewrite;
        }
    }

    private RenameMethod renameMethod(CompileTask task, ExecutableElement method, String newName) {
        TypeElement parent = (TypeElement)method.getEnclosingElement();
        String className = parent.getQualifiedName().toString();
        String methodName = method.getSimpleName().toString();
        String[] erasedParameterTypes = new String[method.getParameters().size()];
        for (int i = 0; i < erasedParameterTypes.length; ++i) {
            TypeMirror type = method.getParameters().get(i).asType();
            erasedParameterTypes[i] = task.task.getTypes().erasure(type).toString();
        }
        return new RenameMethod(className, methodName, erasedParameterTypes, newName);
    }

    private RenameField renameField(CompileTask task, VariableElement field, String newName) {
        TypeElement parent = (TypeElement)field.getEnclosingElement();
        String className = parent.getQualifiedName().toString();
        String fieldName = field.getSimpleName().toString();
        return new RenameField(className, fieldName, newName);
    }

    private RenameVariable renameVariable(CompileTask task, VariableElement variable, String newName) {
        Trees trees = Trees.instance(task.task);
        TreePath path = trees.getPath(variable);
        Path file = Paths.get(path.getCompilationUnit().getSourceFile().toUri());
        long position = trees.getSourcePositions().getStartPosition(path.getCompilationUnit(), path.getLeaf());
        return new RenameVariable(file, (int)position, newName);
    }

    @Override
    public void didOpenTextDocument(DidOpenTextDocumentParams params) {
        FileStore.open(params);
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return;
        }
        this.lastEdited = Paths.get(params.textDocument.uri);
        this.uncheckedChanges = true;
    }

    @Override
    public void didChangeTextDocument(DidChangeTextDocumentParams params) {
        FileStore.change(params);
        this.lastEdited = Paths.get(params.textDocument.uri);
        this.uncheckedChanges = true;
    }

    @Override
    public void didCloseTextDocument(DidCloseTextDocumentParams params) {
        FileStore.close(params);
        if (FileStore.isJavaFile(params.textDocument.uri)) {
            this.client.publishDiagnostics(new PublishDiagnosticsParams(params.textDocument.uri, List.of()));
        }
    }

    @Override
    public List<CodeAction> codeAction(CodeActionParams params) {
        CodeActionProvider provider = new CodeActionProvider(this.compiler());
        if (params.context.diagnostics.isEmpty()) {
            return provider.codeActionsForCursor(params);
        }
        return provider.codeActionForDiagnostics(params);
    }

    @Override
    public void didSaveTextDocument(DidSaveTextDocumentParams params) {
        if (FileStore.isJavaFile(params.textDocument.uri)) {
            this.lint(FileStore.activeDocuments());
        }
    }

    @Override
    public void doAsyncWork() {
        if (this.uncheckedChanges && FileStore.activeDocuments().contains(this.lastEdited)) {
            this.lint(List.of(this.lastEdited));
            this.uncheckedChanges = false;
        }
    }
}

