/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.javacs.lsp.MarkupContent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MarkdownHelper {
    private static final Pattern HTML_TAG = Pattern.compile("<(\\w+)[^>]*>");
    private static final Logger LOG = Logger.getLogger("main");

    public static MarkupContent asMarkupContent(DocCommentTree comment) {
        String markdown = MarkdownHelper.asMarkdown(comment);
        MarkupContent content = new MarkupContent();
        content.kind = "markdown";
        content.value = markdown;
        return content;
    }

    public static String asMarkdown(DocCommentTree comment) {
        List<? extends DocTree> lines = comment.getFirstSentence();
        return MarkdownHelper.asMarkdown(lines);
    }

    private static String asMarkdown(List<? extends DocTree> lines) {
        StringJoiner join = new StringJoiner("\n");
        for (DocTree docTree : lines) {
            join.add(docTree.toString());
        }
        String html = join.toString();
        return MarkdownHelper.asMarkdown(html);
    }

    private static Document parse(String html) {
        try {
            String xml = "<wrapper>" + html + "</wrapper>";
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static void replaceNodes(Document doc, String tagName, Function<String, String> replace) {
        NodeList nodes = doc.getElementsByTagName(tagName);
        while (nodes.getLength() > 0) {
            Node node = nodes.item(0);
            Node parent = node.getParentNode();
            String text = replace.apply(node.getTextContent().trim());
            Text replacement = doc.createTextNode(text);
            parent.replaceChild(replacement, node);
            nodes = doc.getElementsByTagName(tagName);
        }
    }

    private static String print(Document doc) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String wrapped = writer.getBuffer().toString();
            return wrapped.substring("<wrapper>".length(), wrapped.length() - "</wrapper>".length());
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private static void check(CharBuffer in, char expected) {
        char head = in.get();
        if (head != expected) {
            throw new RuntimeException(String.format("want `%s` got `%s`", Character.valueOf(expected), Character.valueOf(head)));
        }
    }

    private static boolean empty(CharBuffer in) {
        return in.position() == in.limit();
    }

    private static char peek(CharBuffer in) {
        return in.get(in.position());
    }

    private static String parseTag(CharBuffer in) {
        MarkdownHelper.check(in, '@');
        StringBuilder tag = new StringBuilder();
        while (!MarkdownHelper.empty(in) && Character.isAlphabetic(MarkdownHelper.peek(in))) {
            tag.append(in.get());
        }
        return tag.toString();
    }

    private static void parseBlock(CharBuffer in, StringBuilder out) {
        MarkdownHelper.check(in, '{');
        if (MarkdownHelper.peek(in) == '@') {
            String tag = MarkdownHelper.parseTag(in);
            if (MarkdownHelper.peek(in) == ' ') {
                in.get();
            }
            switch (tag) {
                case "code": 
                case "link": 
                case "linkplain": {
                    out.append("`");
                    MarkdownHelper.parseInner(in, out);
                    out.append("`");
                    break;
                }
                case "literal": {
                    MarkdownHelper.parseInner(in, out);
                    break;
                }
                default: {
                    LOG.warning(String.format("Unknown tag `@%s`", tag));
                    MarkdownHelper.parseInner(in, out);
                    break;
                }
            }
        } else {
            MarkdownHelper.parseInner(in, out);
        }
        MarkdownHelper.check(in, '}');
    }

    private static void parseInner(CharBuffer in, StringBuilder out) {
        block4: while (!MarkdownHelper.empty(in)) {
            switch (MarkdownHelper.peek(in)) {
                case '{': {
                    MarkdownHelper.parseBlock(in, out);
                    continue block4;
                }
                case '}': {
                    return;
                }
            }
            out.append(in.get());
        }
    }

    private static void parse(CharBuffer in, StringBuilder out) {
        while (!MarkdownHelper.empty(in)) {
            MarkdownHelper.parseInner(in, out);
        }
    }

    private static String replaceTags(String in) {
        StringBuilder out = new StringBuilder();
        MarkdownHelper.parse(CharBuffer.wrap(in), out);
        return out.toString();
    }

    private static String htmlToMarkdown(String html) {
        html = MarkdownHelper.replaceTags(html);
        Document doc = MarkdownHelper.parse(html);
        MarkdownHelper.replaceNodes(doc, "i", contents -> String.format("*%s*", contents));
        MarkdownHelper.replaceNodes(doc, "b", contents -> String.format("**%s**", contents));
        MarkdownHelper.replaceNodes(doc, "pre", contents -> String.format("`%s`", contents));
        MarkdownHelper.replaceNodes(doc, "code", contents -> String.format("`%s`", contents));
        MarkdownHelper.replaceNodes(doc, "a", contents -> contents);
        return MarkdownHelper.print(doc);
    }

    private static boolean isHtml(String text) {
        Matcher tags = HTML_TAG.matcher(text);
        while (tags.find()) {
            String tag = tags.group(1);
            String close = String.format("</%s>", tag);
            int findClose = text.indexOf(close, tags.end());
            if (findClose == -1) continue;
            return true;
        }
        return false;
    }

    static String asMarkdown(String commentText) {
        if (MarkdownHelper.isHtml(commentText)) {
            commentText = MarkdownHelper.htmlToMarkdown(commentText);
        }
        commentText = MarkdownHelper.replaceTags(commentText);
        return commentText;
    }
}

