/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import org.javacs.FileStore;
import org.javacs.SourceFileManager;
import org.javacs.SourceFileObject;
import org.javacs.StringSearch;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;

class Parser {
    private static final JavaCompiler COMPILER = ServiceLoader.load(JavaCompiler.class).iterator().next();
    private static final SourceFileManager FILE_MANAGER = new SourceFileManager();
    final JavaFileObject file;
    final String contents;
    final JavacTask task;
    final CompilationUnitTree root;
    final Trees trees;
    private static Parser cachedParse;
    private static long cachedModified;
    private static final DocCommentTree EMPTY_DOC;
    private static final Logger LOG;

    private static JavacTask singleFileTask(JavaFileObject file) {
        return (JavacTask)COMPILER.getTask(null, FILE_MANAGER, Parser::ignoreError, List.of(), List.of(), List.of(file));
    }

    private Parser(JavaFileObject file) {
        this.file = file;
        try {
            this.contents = file.getCharContent(false).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.task = Parser.singleFileTask(file);
        try {
            this.root = this.task.parse().iterator().next();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.trees = Trees.instance(this.task);
    }

    static Parser parseFile(Path file) {
        return Parser.parseJavaFileObject(new SourceFileObject(file));
    }

    private static boolean needsParse(JavaFileObject file) {
        if (cachedParse == null) {
            return true;
        }
        if (!Parser.cachedParse.file.equals(file)) {
            return true;
        }
        return file.getLastModified() > cachedModified;
    }

    private static void loadParse(JavaFileObject file) {
        cachedParse = new Parser(file);
        cachedModified = file.getLastModified();
    }

    static Parser parseJavaFileObject(JavaFileObject file) {
        if (Parser.needsParse(file)) {
            Parser.loadParse(file);
        } else {
            LOG.info("...using cached parse");
        }
        return cachedParse;
    }

    Set<Name> packagePrivateClasses() {
        HashSet<Name> result = new HashSet<Name>();
        for (Tree tree : this.root.getTypeDecls()) {
            ClassTree c;
            boolean isPublic;
            if (!(tree instanceof ClassTree) || (isPublic = (c = (ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC))) continue;
            result.add(c.getSimpleName());
        }
        return result;
    }

    static Range range(JavacTask task, CharSequence contents, TreePath path) {
        String name;
        Trees trees = Trees.instance(task);
        SourcePositions pos = trees.getSourcePositions();
        CompilationUnitTree root = path.getCompilationUnit();
        LineMap lines = root.getLineMap();
        int start = (int)pos.getStartPosition(root, path.getLeaf());
        int end = (int)pos.getEndPosition(root, path.getLeaf());
        if (start == -1) {
            LOG.warning(String.format("Couldn't locate `%s`", path.getLeaf()));
            return Range.NONE;
        }
        if (end == -1) {
            end = start + path.getLeaf().toString().length();
        }
        if (path.getLeaf() instanceof ClassTree) {
            ClassTree cls = (ClassTree)path.getLeaf();
            if (!cls.getModifiers().getAnnotations().isEmpty()) {
                start = (int)pos.getEndPosition(root, cls.getModifiers());
            }
            if ((start = Parser.indexOf(contents, name = cls.getSimpleName().toString(), start)) == -1) {
                LOG.warning(String.format("Couldn't find identifier `%s` in `%s`", name, path.getLeaf()));
                return Range.NONE;
            }
            end = start + name.length();
        }
        if (path.getLeaf() instanceof MethodTree) {
            MethodTree method = (MethodTree)path.getLeaf();
            if (!method.getModifiers().getAnnotations().isEmpty()) {
                start = (int)pos.getEndPosition(root, method.getModifiers());
            }
            if ((name = method.getName().toString()).equals("<init>")) {
                name = Parser.className(path);
            }
            if ((start = Parser.indexOf(contents, name, start)) == -1) {
                LOG.warning(String.format("Couldn't find identifier `%s` in `%s`", name, path.getLeaf()));
                return Range.NONE;
            }
            end = start + name.length();
        }
        if (path.getLeaf() instanceof VariableTree) {
            VariableTree field = (VariableTree)path.getLeaf();
            if (!field.getModifiers().getAnnotations().isEmpty()) {
                start = (int)pos.getEndPosition(root, field.getModifiers());
            }
            if ((start = Parser.indexOf(contents, name = field.getName().toString(), start)) == -1) {
                LOG.warning(String.format("Couldn't find identifier `%s` in `%s`", name, path.getLeaf()));
                return Range.NONE;
            }
            end = start + name.length();
        }
        if (path.getLeaf() instanceof MemberSelectTree) {
            MemberSelectTree member = (MemberSelectTree)path.getLeaf();
            name = member.getIdentifier().toString();
            start = Parser.indexOf(contents, name, start);
            if (start == -1) {
                LOG.warning(String.format("Couldn't find identifier `%s` in `%s`", name, path.getLeaf()));
                return Range.NONE;
            }
            end = start + name.length();
        }
        int startLine = (int)lines.getLineNumber(start);
        int startCol = (int)lines.getColumnNumber(start);
        int endLine = (int)lines.getLineNumber(end);
        int endCol = (int)lines.getColumnNumber(end);
        Range range = new Range(new Position(startLine - 1, startCol - 1), new Position(endLine - 1, endCol - 1));
        return range;
    }

    private static int indexOf(CharSequence contents, String name, int start) {
        Matcher matcher = Pattern.compile("\\b" + name + "\\b").matcher(contents);
        if (matcher.find(start)) {
            return matcher.start();
        }
        return -1;
    }

    private static DocCommentTree makeEmptyDoc() {
        CompilationUnitTree root;
        SourceFileObject file = new SourceFileObject(Paths.get("/Foo.java", new String[0]), "/** */ class Foo { }", Instant.now());
        JavacTask task = (JavacTask)COMPILER.getTask(null, FILE_MANAGER, Parser::ignoreError, List.of(), null, Collections.singletonList(file));
        DocTrees docs = DocTrees.instance(task);
        try {
            root = task.parse().iterator().next();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        class FindEmptyDoc
        extends TreePathScanner<Void, Void> {
            DocCommentTree found;
            final /* synthetic */ DocTrees val$docs;

            FindEmptyDoc(DocTrees docTrees) {
                this.val$docs = docTrees;
            }

            @Override
            public Void visitClass(ClassTree t, Void __) {
                this.found = this.val$docs.getDocCommentTree(this.getCurrentPath());
                return null;
            }
        }
        FindEmptyDoc find = new FindEmptyDoc(docs);
        find.scan(root, null);
        return Objects.requireNonNull(find.found);
    }

    private static void ignoreError(Diagnostic<? extends JavaFileObject> __) {
    }

    static String describeTree(Tree leaf) {
        if (leaf instanceof MethodTree) {
            MethodTree method = (MethodTree)leaf;
            StringJoiner params = new StringJoiner(", ");
            for (VariableTree variableTree : method.getParameters()) {
                params.add(String.valueOf(variableTree.getType()) + " " + String.valueOf(variableTree.getName()));
            }
            return String.valueOf(method.getName()) + "(" + String.valueOf(params) + ")";
        }
        if (leaf instanceof ClassTree) {
            ClassTree cls = (ClassTree)leaf;
            return "class " + String.valueOf(cls.getSimpleName());
        }
        if (leaf instanceof BlockTree) {
            BlockTree block = (BlockTree)leaf;
            return String.format("{ ...%d lines... }", block.getStatements().size());
        }
        return leaf.toString();
    }

    List<String> accessibleClasses(String partialName, String fromPackage) {
        String toPackage = Objects.toString(this.root.getPackageName(), "");
        boolean samePackage = fromPackage.equals(toPackage) || toPackage.isEmpty();
        ArrayList<String> result = new ArrayList<String>();
        for (Tree tree : this.root.getTypeDecls()) {
            Object name;
            if (!(tree instanceof ClassTree)) continue;
            ClassTree cls = (ClassTree)tree;
            boolean isPublic = cls.getModifiers().getFlags().contains((Object)Modifier.PUBLIC);
            if (!samePackage && !isPublic || !StringSearch.matchesPartialName((CharSequence)(name = cls.getSimpleName().toString()), partialName)) continue;
            if (this.root.getPackageName() != null) {
                name = String.valueOf(this.root.getPackageName()) + "." + (String)name;
            }
            result.add((String)name);
        }
        return result;
    }

    private static String prune(final CompilationUnitTree root, final SourcePositions pos, final StringBuilder buffer, final long[] offsets, final boolean eraseAfterCursor) {
        class Scan
        extends TreeScanner<Void, Void> {
            boolean erasedAfterCursor;

            Scan() {
                this.erasedAfterCursor = !eraseAfterCursor;
            }

            boolean containsCursor(Tree node) {
                long start = pos.getStartPosition(root, node);
                long end = pos.getEndPosition(root, node);
                for (long cursor : offsets) {
                    if (start > cursor || cursor > end) continue;
                    return true;
                }
                return false;
            }

            boolean anyContainsCursor(Collection<? extends Tree> nodes) {
                for (Tree tree : nodes) {
                    if (!this.containsCursor(tree)) continue;
                    return true;
                }
                return false;
            }

            long lastCursorIn(Tree node) {
                long start = pos.getStartPosition(root, node);
                long end = pos.getEndPosition(root, node);
                long last = -1L;
                for (long cursor : offsets) {
                    if (start > cursor || cursor > end) continue;
                    last = cursor;
                }
                if (last == -1L) {
                    throw new RuntimeException(String.format("No cursor in %s is between %d and %d", offsets, start, end));
                }
                return last;
            }

            @Override
            public Void visitImport(ImportTree node, Void __) {
                if (this.containsCursor(node) && node.isStatic()) {
                    int start = (int)pos.getStartPosition(root, node);
                    start = buffer.indexOf("static", start);
                    int end = start + "static".length();
                    Parser.erase(buffer, start, end);
                }
                return (Void)super.visitImport(node, null);
            }

            @Override
            public Void visitSwitch(SwitchTree node, Void __) {
                if (this.containsCursor(node)) {
                    this.erasedAfterCursor = true;
                }
                return (Void)super.visitSwitch(node, null);
            }

            @Override
            public Void visitBlock(BlockTree node, Void __) {
                if (this.containsCursor(node)) {
                    super.visitBlock(node, null);
                    if (!this.erasedAfterCursor) {
                        long cursor;
                        long start = cursor = this.lastCursorIn(node);
                        long end = pos.getEndPosition(root, node);
                        if (end >= (long)buffer.length()) {
                            end = buffer.length() - 1;
                        }
                        while (start < end && buffer.charAt((int)start) != '\n') {
                            ++start;
                        }
                        while (end > start && buffer.charAt((int)end) != '}') {
                            --end;
                        }
                        Parser.erase(buffer, start, end - 1L);
                        this.erasedAfterCursor = true;
                    }
                } else if (!node.getStatements().isEmpty()) {
                    StatementTree first = node.getStatements().get(0);
                    StatementTree last = node.getStatements().get(node.getStatements().size() - 1);
                    long start = pos.getStartPosition(root, first);
                    long end = pos.getEndPosition(root, last);
                    if (end >= (long)buffer.length()) {
                        end = buffer.length() - 1;
                    }
                    Parser.erase(buffer, start, end);
                }
                return null;
            }

            @Override
            public Void visitErroneous(ErroneousTree node, Void nothing) {
                return (Void)super.scan(node.getErrorTrees(), nothing);
            }
        }
        new Scan().scan(root, null);
        String pruned = buffer.toString();
        return pruned;
    }

    private static void erase(StringBuilder buffer, long start, long end) {
        int i = (int)start;
        while ((long)i < end) {
            switch (buffer.charAt(i)) {
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    buffer.setCharAt(i, ' ');
                }
            }
            ++i;
        }
    }

    String prune(long cursor) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        StringBuilder buffer = new StringBuilder(this.contents);
        long[] cursors = new long[]{cursor};
        return Parser.prune(this.root, pos, buffer, cursors, true);
    }

    static Optional<Path> declaringFile(Element e) {
        LOG.info(String.format("...looking up declaring file of `%s`...", e));
        Optional<TypeElement> top = Parser.topLevelDeclaration(e);
        if (!top.isPresent()) {
            LOG.warning("...no top-level type!");
            return Optional.empty();
        }
        LOG.info(String.format("...top-level type is %s", top.get()));
        Optional<Path> file = FileStore.findDeclaringFile(top.get());
        if (!file.isPresent()) {
            LOG.info(String.format("...couldn't find declaring file for type", new Object[0]));
            return Optional.empty();
        }
        return file;
    }

    private static Optional<TypeElement> topLevelDeclaration(Element e) {
        if (e == null) {
            return Optional.empty();
        }
        Element parent = e;
        TypeElement result = null;
        while (parent.getEnclosingElement() != null) {
            if (parent instanceof TypeElement) {
                result = (TypeElement)parent;
            }
            parent = parent.getEnclosingElement();
        }
        return Optional.ofNullable(result);
    }

    static String className(TreePath t) {
        while (t != null) {
            if (t.getLeaf() instanceof ClassTree) {
                ClassTree cls = (ClassTree)t.getLeaf();
                return cls.getSimpleName().toString();
            }
            t = t.getParentPath();
        }
        return "";
    }

    static {
        cachedModified = -1L;
        EMPTY_DOC = Parser.makeEmptyDoc();
        LOG = Logger.getLogger("main");
    }
}

