/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

class ReusableCompiler {
    private static final Logger LOG = Logger.getLogger("main");
    private static final JavacTool systemProvider = JavacTool.create();
    private List<String> currentOptions = new ArrayList<String>();
    private ReusableContext currentContext;
    private boolean checkedOut;

    ReusableCompiler() {
    }

    Borrow getTask(JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        if (this.checkedOut) {
            throw new RuntimeException("Compiler is already in-use!");
        }
        this.checkedOut = true;
        List opts = StreamSupport.stream(options.spliterator(), false).collect(Collectors.toCollection(ArrayList::new));
        if (!opts.equals(this.currentOptions)) {
            LOG.warning(String.format("Options changed from %s to %s, creating new compiler", options, opts));
            this.currentOptions = opts;
            this.currentContext = new ReusableContext(opts);
        }
        JavacTaskImpl task = (JavacTaskImpl)systemProvider.getTask(null, fileManager, diagnosticListener, opts, classes, compilationUnits, this.currentContext);
        task.addTaskListener(this.currentContext);
        return new Borrow(task, this.currentContext);
    }

    static class ReusableContext
    extends Context
    implements TaskListener {
        List<String> arguments;

        ReusableContext(List<String> arguments) {
            this.arguments = arguments;
            this.put(Log.logKey, ReusableLog.factory);
            this.put(JavaCompiler.compilerKey, ReusableJavaCompiler.factory);
        }

        void clear() {
            this.drop(Arguments.argsKey);
            this.drop(DiagnosticListener.class);
            this.drop(Log.outKey);
            this.drop(Log.errKey);
            this.drop(JavaFileManager.class);
            this.drop(JavacTask.class);
            this.drop(JavacTrees.class);
            this.drop(JavacElements.class);
            if (this.ht.get(Log.logKey) instanceof ReusableLog) {
                ((ReusableLog)Log.instance(this)).clear();
                Enter.instance(this).newRound();
                ((ReusableJavaCompiler)ReusableJavaCompiler.instance(this)).clear();
                Types.instance(this).newRound();
                Check.instance(this).newRound();
                Modules.instance(this).newRound();
                Annotate.instance(this).newRound();
                CompileStates.instance(this).clear();
                MultiTaskListener.instance(this).clear();
            }
        }

        @Override
        public void finished(TaskEvent e) {
        }

        @Override
        public void started(TaskEvent e) {
        }

        <T> void drop(Context.Key<T> k) {
            this.ht.remove(k);
        }

        <T> void drop(Class<T> c) {
            this.ht.remove(this.key(c));
        }

        static class ReusableLog
        extends Log {
            static final Context.Factory<Log> factory = ReusableLog::new;
            Context context;

            ReusableLog(Context context) {
                super(context);
                this.context = context;
            }

            void clear() {
                this.recorded.clear();
                this.sourceMap.clear();
                this.nerrors = 0;
                this.nwarnings = 0;
                this.diagListener = new DiagnosticListener<JavaFileObject>(){
                    DiagnosticListener<JavaFileObject> cachedListener;

                    @Override
                    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                        if (this.cachedListener == null) {
                            this.cachedListener = context.get(DiagnosticListener.class);
                        }
                        this.cachedListener.report(diagnostic);
                    }
                };
            }
        }

        static class ReusableJavaCompiler
        extends JavaCompiler {
            static final Context.Factory<JavaCompiler> factory = ReusableJavaCompiler::new;

            ReusableJavaCompiler(Context context) {
                super(context);
            }

            @Override
            public void close() {
            }

            void clear() {
                this.newRound();
            }

            @Override
            protected void checkReusable() {
            }
        }
    }

    class Borrow
    implements AutoCloseable {
        final JavacTask task;
        boolean closed;

        Borrow(JavacTask task, ReusableContext ctx) {
            this.task = task;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            ReusableCompiler.this.currentContext.clear();
            try {
                Method method = JavacTaskImpl.class.getDeclaredMethod("cleanup", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)this.task, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            ReusableCompiler.this.checkedOut = false;
            this.closed = true;
        }
    }
}

