/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.javacs.FileStore;
import org.javacs.SourceFileObject;
import org.javacs.StringSearch;

class SourceFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private static final Logger LOG = Logger.getLogger("main");

    SourceFileManager() {
        super(SourceFileManager.createDelegateFileManager());
    }

    private static StandardJavaFileManager createDelegateFileManager() {
        JavaCompiler compiler = ServiceLoader.load(JavaCompiler.class).iterator().next();
        return compiler.getStandardFileManager(SourceFileManager::logError, null, Charset.defaultCharset());
    }

    private static void logError(Diagnostic<?> error) {
        LOG.warning(error.getMessage(null));
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (location == StandardLocation.SOURCE_PATH) {
            Stream<JavaFileObject> stream = FileStore.list(packageName).stream().map(this::asJavaFileObject);
            return stream::iterator;
        }
        return super.list(location, packageName, kinds, recurse);
    }

    private JavaFileObject asJavaFileObject(Path file) {
        return new SourceFileObject(file);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location == StandardLocation.SOURCE_PATH) {
            SourceFileObject source = (SourceFileObject)file;
            String packageName = FileStore.packageName(source.path);
            Object className = this.removeExtension(source.path.getFileName().toString());
            if (!packageName.isEmpty()) {
                className = packageName + "." + (String)className;
            }
            return className;
        }
        return super.inferBinaryName(location, file);
    }

    private String removeExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        return lastDot == -1 ? fileName : fileName.substring(0, lastDot);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.SOURCE_PATH || super.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location == StandardLocation.SOURCE_PATH) {
            String packageName = StringSearch.mostName(className);
            String simpleClassName = StringSearch.lastName(className);
            for (Path f : FileStore.list(packageName)) {
                if (!f.getFileName().toString().equals(simpleClassName + kind.extension)) continue;
                return new SourceFileObject(f);
            }
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        if (location == StandardLocation.SOURCE_PATH) {
            return null;
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject file) throws IOException {
        if (location == StandardLocation.SOURCE_PATH) {
            SourceFileObject source = (SourceFileObject)file;
            return FileStore.contains(source.path);
        }
        return super.contains(location, file);
    }

    void setLocation(JavaFileManager.Location location, Iterable<? extends File> files) throws IOException {
        ((StandardJavaFileManager)this.fileManager).setLocation(location, files);
    }

    void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> searchpath) throws IOException {
        ((StandardJavaFileManager)this.fileManager).setLocationFromPaths(location, searchpath);
    }
}

