/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.javacs.FileStore;

public class SourceFileObject
implements JavaFileObject {
    final Path path;
    final String contents;
    final Instant modified;

    public SourceFileObject(Path path) {
        this(path, null, Instant.EPOCH);
    }

    public SourceFileObject(Path path, String contents, Instant modified) {
        if (!FileStore.isJavaFile(path)) {
            throw new RuntimeException(String.valueOf(path) + " is not a java source");
        }
        this.path = path;
        this.contents = contents;
        this.modified = modified;
    }

    public boolean equals(Object other) {
        if (other.getClass() != SourceFileObject.class) {
            return false;
        }
        SourceFileObject that = (SourceFileObject)other;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        String name = this.path.getFileName().toString();
        return SourceFileObject.kindFromExtension(name);
    }

    private static JavaFileObject.Kind kindFromExtension(String name) {
        for (JavaFileObject.Kind candidate : JavaFileObject.Kind.values()) {
            if (!name.endsWith(candidate.extension)) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return this.path.getFileName().toString().equals(simpleName + kind.extension);
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public URI toUri() {
        return this.path.toUri();
    }

    @Override
    public String getName() {
        return this.path.toString();
    }

    @Override
    public InputStream openInputStream() {
        if (this.contents != null) {
            byte[] bytes = this.contents.getBytes();
            return new ByteArrayInputStream(bytes);
        }
        return FileStore.inputStream(this.path);
    }

    @Override
    public OutputStream openOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) {
        if (this.contents != null) {
            return new StringReader(this.contents);
        }
        return FileStore.bufferedReader(this.path);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        if (this.contents != null) {
            return this.contents;
        }
        return FileStore.contents(this.path);
    }

    @Override
    public Writer openWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        if (this.contents != null) {
            return this.modified.toEpochMilli();
        }
        return FileStore.modified(this.path).toEpochMilli();
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.path.toString();
    }
}

