/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.completion;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.CompletionData;
import org.javacs.FileStore;
import org.javacs.JsonHelper;
import org.javacs.ParseTask;
import org.javacs.SourceFileObject;
import org.javacs.StringSearch;
import org.javacs.completion.FindCompletionsAt;
import org.javacs.completion.PruneMethodBodies;
import org.javacs.completion.ScopeHelper;
import org.javacs.lsp.Command;
import org.javacs.lsp.CompletionItem;
import org.javacs.lsp.CompletionList;

public class CompletionProvider {
    private final CompilerProvider compiler;
    public static final CompletionList NOT_SUPPORTED = new CompletionList(false, List.of());
    public static final int MAX_COMPLETION_ITEMS = 50;
    private static final String[] TOP_LEVEL_KEYWORDS = new String[]{"package", "import", "public", "private", "protected", "abstract", "class", "interface", "@interface", "extends", "implements"};
    private static final String[] CLASS_BODY_KEYWORDS = new String[]{"public", "private", "protected", "static", "final", "native", "synchronized", "abstract", "default", "class", "interface", "void", "boolean", "int", "long", "float", "double"};
    private static final String[] METHOD_BODY_KEYWORDS = new String[]{"new", "assert", "try", "catch", "finally", "throw", "return", "break", "case", "continue", "default", "do", "while", "for", "switch", "if", "else", "instanceof", "var", "final", "class", "void", "boolean", "int", "long", "float", "double"};
    private static final CompletionList EMPTY = new CompletionList(false, List.of());
    private static final Logger LOG = Logger.getLogger("main");

    public CompletionProvider(CompilerProvider compiler) {
        this.compiler = compiler;
    }

    public CompletionList complete(Path file, int line, int column) {
        LOG.info("Complete at " + String.valueOf(file.getFileName()) + "(" + line + "," + column + ")...");
        Instant started = Instant.now();
        ParseTask task = this.compiler.parse(file);
        long cursor = task.root.getLineMap().getPosition(line, column);
        StringBuilder contents = (StringBuilder)new PruneMethodBodies(task.task).scan(task.root, Long.valueOf(cursor));
        int endOfLine = this.endOfLine(contents, (int)cursor);
        contents.insert(endOfLine, ';');
        CompletionList list = this.compileAndComplete(file, contents.toString(), cursor);
        this.addTopLevelSnippets(task, list);
        this.logCompletionTiming(started, list.items, list.isIncomplete);
        return list;
    }

    private int endOfLine(CharSequence contents, int cursor) {
        char c;
        while (cursor < contents.length() && (c = contents.charAt(cursor)) != '\r' && c != '\n') {
            ++cursor;
        }
        return cursor;
    }

    private CompletionList compileAndComplete(Path file, String contents, long cursor) {
        Instant started = Instant.now();
        SourceFileObject source = new SourceFileObject(file, contents, Instant.now());
        String partial = this.partialIdentifier(contents, (int)cursor);
        boolean endsWithParen = this.endsWithParen(contents, (int)cursor);
        try (CompileTask task = this.compiler.compile(List.of(source));){
            LOG.info("...compiled in " + Duration.between(started, Instant.now()).toMillis() + "ms");
            TreePath path = (TreePath)new FindCompletionsAt(task.task).scan(task.root(), Long.valueOf(cursor));
            switch (path.getLeaf().getKind()) {
                case IDENTIFIER: {
                    CompletionList completionList = this.completeIdentifier(task, path, partial, endsWithParen);
                    return completionList;
                }
                case MEMBER_SELECT: {
                    CompletionList completionList = this.completeMemberSelect(task, path, partial, endsWithParen);
                    return completionList;
                }
                case MEMBER_REFERENCE: {
                    CompletionList completionList = this.completeMemberReference(task, path, partial);
                    return completionList;
                }
                case SWITCH: {
                    CompletionList completionList = this.completeSwitchConstant(task, path, partial);
                    return completionList;
                }
                case IMPORT: {
                    CompletionList completionList = this.completeImport(this.qualifiedPartialIdentifier(contents, (int)cursor));
                    return completionList;
                }
            }
            CompletionList list = new CompletionList();
            this.addKeywords(path, partial, list);
            CompletionList completionList = list;
            return completionList;
        }
    }

    private void addTopLevelSnippets(ParseTask task, CompletionList list) {
        Path file = Paths.get(task.root.getSourceFile().toUri());
        if (!this.hasTypeDeclaration(task.root)) {
            list.items.add(this.classSnippet(file));
            if (task.root.getPackage() == null) {
                list.items.add(this.packageSnippet(file));
            }
        }
    }

    private boolean hasTypeDeclaration(CompilationUnitTree root) {
        for (Tree tree : root.getTypeDecls()) {
            if (tree.getKind() == Tree.Kind.ERRONEOUS) continue;
            return true;
        }
        return false;
    }

    private CompletionItem packageSnippet(Path file) {
        String name = FileStore.suggestedPackageName(file);
        return this.snippetItem("package " + name, "package " + name + ";\n\n");
    }

    private CompletionItem classSnippet(Path file) {
        String name = file.getFileName().toString();
        name = name.substring(0, name.length() - ".java".length());
        return this.snippetItem("class " + name, "class " + name + " {\n    $0\n}");
    }

    private String partialIdentifier(String contents, int end) {
        int start;
        for (start = end; start > 0 && Character.isJavaIdentifierPart(contents.charAt(start - 1)); --start) {
        }
        return contents.substring(start, end);
    }

    private boolean endsWithParen(String contents, int cursor) {
        for (int i = cursor; i < contents.length(); ++i) {
            if (Character.isJavaIdentifierPart(contents.charAt(i))) continue;
            return contents.charAt(i) == '(';
        }
        return false;
    }

    private String qualifiedPartialIdentifier(String contents, int end) {
        int start;
        for (start = end; start > 0 && this.isQualifiedIdentifierChar(contents.charAt(start - 1)); --start) {
        }
        return contents.substring(start, end);
    }

    private boolean isQualifiedIdentifierChar(char c) {
        return c == '.' || Character.isJavaIdentifierPart(c);
    }

    private CompletionList completeIdentifier(CompileTask task, TreePath path, String partial, boolean endsWithParen) {
        LOG.info("...complete identifiers");
        CompletionList list = new CompletionList();
        list.items = this.completeUsingScope(task, path, partial, endsWithParen);
        this.addStaticImports(task, path.getCompilationUnit(), partial, endsWithParen, list);
        if (!list.isIncomplete && partial.length() > 0 && Character.isUpperCase(partial.charAt(0))) {
            this.addClassNames(path.getCompilationUnit(), partial, list);
        }
        this.addKeywords(path, partial, list);
        return list;
    }

    private void addKeywords(TreePath path, String partial, CompletionList list) {
        Tree level = this.findKeywordLevel(path);
        String[] keywords = new String[]{};
        if (level instanceof CompilationUnitTree) {
            keywords = TOP_LEVEL_KEYWORDS;
        } else if (level instanceof ClassTree) {
            keywords = CLASS_BODY_KEYWORDS;
        } else if (level instanceof MethodTree) {
            keywords = METHOD_BODY_KEYWORDS;
        }
        for (String k : keywords) {
            if (!StringSearch.matchesPartialName(k, partial)) continue;
            list.items.add(this.keyword(k));
        }
    }

    private Tree findKeywordLevel(TreePath path) {
        while (path != null) {
            if (path.getLeaf() instanceof CompilationUnitTree || path.getLeaf() instanceof ClassTree || path.getLeaf() instanceof MethodTree) {
                return path.getLeaf();
            }
            path = path.getParentPath();
        }
        throw new RuntimeException("empty path");
    }

    private List<CompletionItem> completeUsingScope(CompileTask task, TreePath path, String partial, boolean endsWithParen) {
        Trees trees = Trees.instance(task.task);
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>();
        HashMap<String, List<ExecutableElement>> methods = new HashMap<String, List<ExecutableElement>>();
        Scope scope = trees.getScope(path);
        Predicate<CharSequence> filter = name -> StringSearch.matchesPartialName(name, partial);
        for (Element member : ScopeHelper.scopeMembers(task, scope, filter)) {
            if (member.getKind() == ElementKind.METHOD) {
                this.putMethod((ExecutableElement)member, methods);
                continue;
            }
            list.add(this.item(task, member));
        }
        for (List overloads : methods.values()) {
            list.add(this.method(task, overloads, !endsWithParen));
        }
        LOG.info("...found " + list.size() + " scope members");
        return list;
    }

    private void addStaticImports(CompileTask task, CompilationUnitTree root, String partial, boolean endsWithParen, CompletionList list) {
        Trees trees = Trees.instance(task.task);
        HashMap<String, List<ExecutableElement>> methods = new HashMap<String, List<ExecutableElement>>();
        int previousSize = list.items.size();
        block0: for (ImportTree importTree : root.getImports()) {
            MemberSelectTree id;
            if (!importTree.isStatic() || !this.importMatchesPartial((id = (MemberSelectTree)importTree.getQualifiedIdentifier()).getIdentifier(), partial)) continue;
            TreePath path = trees.getPath(root, id.getExpression());
            TypeElement type = (TypeElement)trees.getElement(path);
            for (Element element : type.getEnclosedElements()) {
                if (!element.getModifiers().contains((Object)Modifier.STATIC) || !this.memberMatchesImport(id.getIdentifier(), element) || !StringSearch.matchesPartialName(element.getSimpleName(), partial)) continue;
                if (element.getKind() == ElementKind.METHOD) {
                    this.putMethod((ExecutableElement)element, methods);
                } else {
                    list.items.add(this.item(task, element));
                }
                if (list.items.size() + methods.size() <= 50) continue;
                list.isIncomplete = true;
                break block0;
            }
        }
        for (List list2 : methods.values()) {
            list.items.add(this.method(task, list2, !endsWithParen));
        }
        LOG.info("...found " + (list.items.size() - previousSize) + " static imports");
    }

    private boolean importMatchesPartial(Name staticImport, String partial) {
        return staticImport.contentEquals("*") || StringSearch.matchesPartialName(staticImport, partial);
    }

    private boolean memberMatchesImport(Name staticImport, Element member) {
        return staticImport.contentEquals("*") || staticImport.contentEquals(member.getSimpleName());
    }

    private void addClassNames(CompilationUnitTree root, String partial, CompletionList list) {
        String packageName = Objects.toString(root.getPackageName(), "");
        HashSet<String> uniques = new HashSet<String>();
        int previousSize = list.items.size();
        for (String className : this.compiler.packagePrivateTopLevelTypes(packageName)) {
            if (!StringSearch.matchesPartialName(className, partial)) continue;
            list.items.add(this.classItem(className));
            uniques.add(className);
        }
        for (String className : this.compiler.publicTopLevelTypes()) {
            if (!StringSearch.matchesPartialName(this.simpleName(className), partial) || uniques.contains(className)) continue;
            if (list.items.size() > 50) {
                list.isIncomplete = true;
                break;
            }
            list.items.add(this.classItem(className));
            uniques.add(className);
        }
        LOG.info("...found " + (list.items.size() - previousSize) + " class names");
    }

    private CompletionList completeMemberSelect(CompileTask task, TreePath path, String partial, boolean endsWithParen) {
        Trees trees = Trees.instance(task.task);
        MemberSelectTree select = (MemberSelectTree)path.getLeaf();
        LOG.info("...complete members of " + String.valueOf(select.getExpression()));
        path = new TreePath(path, select.getExpression());
        boolean isStatic = trees.getElement(path) instanceof TypeElement;
        Scope scope = trees.getScope(path);
        TypeMirror type = trees.getTypeMirror(path);
        if (type instanceof ArrayType) {
            return this.completeArrayMemberSelect(isStatic);
        }
        if (type instanceof TypeVariable) {
            return this.completeTypeVariableMemberSelect(task, scope, (TypeVariable)type, isStatic, partial, endsWithParen);
        }
        if (type instanceof DeclaredType) {
            return this.completeDeclaredTypeMemberSelect(task, scope, (DeclaredType)type, isStatic, partial, endsWithParen);
        }
        return NOT_SUPPORTED;
    }

    private CompletionList completeArrayMemberSelect(boolean isStatic) {
        if (isStatic) {
            return EMPTY;
        }
        CompletionList list = new CompletionList();
        list.items.add(this.keyword("length"));
        return list;
    }

    private CompletionList completeTypeVariableMemberSelect(CompileTask task, Scope scope, TypeVariable type, boolean isStatic, String partial, boolean endsWithParen) {
        if (type.getUpperBound() instanceof DeclaredType) {
            return this.completeDeclaredTypeMemberSelect(task, scope, (DeclaredType)type.getUpperBound(), isStatic, partial, endsWithParen);
        }
        if (type.getUpperBound() instanceof TypeVariable) {
            return this.completeTypeVariableMemberSelect(task, scope, (TypeVariable)type.getUpperBound(), isStatic, partial, endsWithParen);
        }
        return NOT_SUPPORTED;
    }

    private CompletionList completeDeclaredTypeMemberSelect(CompileTask task, Scope scope, DeclaredType type, boolean isStatic, String partial, boolean endsWithParen) {
        Trees trees = Trees.instance(task.task);
        TypeElement typeElement = (TypeElement)type.asElement();
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>();
        HashMap<String, List<ExecutableElement>> methods = new HashMap<String, List<ExecutableElement>>();
        for (Element element : task.task.getElements().getAllMembers(typeElement)) {
            if (element.getKind() == ElementKind.CONSTRUCTOR || !StringSearch.matchesPartialName(element.getSimpleName(), partial) || !trees.isAccessible(scope, element, type) || isStatic != element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            if (element.getKind() == ElementKind.METHOD) {
                this.putMethod((ExecutableElement)element, methods);
                continue;
            }
            list.add(this.item(task, element));
        }
        for (List list2 : methods.values()) {
            list.add(this.method(task, list2, !endsWithParen));
        }
        if (isStatic) {
            list.add(this.keyword("class"));
        }
        if (isStatic && this.isEnclosingClass(type, scope)) {
            list.add(this.keyword("this"));
            list.add(this.keyword("super"));
        }
        return new CompletionList(false, list);
    }

    private boolean isEnclosingClass(DeclaredType type, Scope start) {
        for (Scope s : ScopeHelper.fastScopes(start)) {
            ExecutableElement method = s.getEnclosingMethod();
            if (method != null && method.getModifiers().contains((Object)Modifier.STATIC)) {
                return false;
            }
            TypeElement thisElement = s.getEnclosingClass();
            if (thisElement != null && thisElement.asType().equals(type)) {
                return true;
            }
            if (thisElement == null || !thisElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            return false;
        }
        return false;
    }

    private CompletionList completeMemberReference(CompileTask task, TreePath path, String partial) {
        Trees trees = Trees.instance(task.task);
        MemberReferenceTree select = (MemberReferenceTree)path.getLeaf();
        LOG.info("...complete methods of " + String.valueOf(select.getQualifierExpression()));
        path = new TreePath(path, select.getQualifierExpression());
        Element element = trees.getElement(path);
        boolean isStatic = element instanceof TypeElement;
        Scope scope = trees.getScope(path);
        TypeMirror type = trees.getTypeMirror(path);
        if (type instanceof ArrayType) {
            return this.completeArrayMemberReference(isStatic);
        }
        if (type instanceof TypeVariable) {
            return this.completeTypeVariableMemberReference(task, scope, (TypeVariable)type, isStatic, partial);
        }
        if (type instanceof DeclaredType) {
            return this.completeDeclaredTypeMemberReference(task, scope, (DeclaredType)type, isStatic, partial);
        }
        return NOT_SUPPORTED;
    }

    private CompletionList completeArrayMemberReference(boolean isStatic) {
        if (isStatic) {
            CompletionList list = new CompletionList();
            list.items.add(this.keyword("new"));
            return list;
        }
        return EMPTY;
    }

    private CompletionList completeTypeVariableMemberReference(CompileTask task, Scope scope, TypeVariable type, boolean isStatic, String partial) {
        if (type.getUpperBound() instanceof DeclaredType) {
            return this.completeDeclaredTypeMemberReference(task, scope, (DeclaredType)type.getUpperBound(), isStatic, partial);
        }
        if (type.getUpperBound() instanceof TypeVariable) {
            return this.completeTypeVariableMemberReference(task, scope, (TypeVariable)type.getUpperBound(), isStatic, partial);
        }
        return NOT_SUPPORTED;
    }

    private CompletionList completeDeclaredTypeMemberReference(CompileTask task, Scope scope, DeclaredType type, boolean isStatic, String partial) {
        Trees trees = Trees.instance(task.task);
        TypeElement typeElement = (TypeElement)type.asElement();
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>();
        HashMap<String, List<ExecutableElement>> methods = new HashMap<String, List<ExecutableElement>>();
        for (Element element : task.task.getElements().getAllMembers(typeElement)) {
            if (!StringSearch.matchesPartialName(element.getSimpleName(), partial) || element.getKind() != ElementKind.METHOD || !trees.isAccessible(scope, element, type) || !isStatic && element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            if (element.getKind() == ElementKind.METHOD) {
                this.putMethod((ExecutableElement)element, methods);
                continue;
            }
            list.add(this.item(task, element));
        }
        for (List list2 : methods.values()) {
            list.add(this.method(task, list2, false));
        }
        if (isStatic) {
            list.add(this.keyword("new"));
        }
        return new CompletionList(false, list);
    }

    private void putMethod(ExecutableElement method, Map<String, List<ExecutableElement>> methods) {
        String name = method.getSimpleName().toString();
        if (!methods.containsKey(name)) {
            methods.put(name, new ArrayList());
        }
        methods.get(name).add(method);
    }

    private CompletionList completeSwitchConstant(CompileTask task, TreePath path, String partial) {
        SwitchTree switchTree = (SwitchTree)path.getLeaf();
        path = new TreePath(path, switchTree.getExpression());
        TypeMirror type = Trees.instance(task.task).getTypeMirror(path);
        LOG.info("...complete constants of type " + String.valueOf(type));
        if (!(type instanceof DeclaredType)) {
            return NOT_SUPPORTED;
        }
        DeclaredType declared = (DeclaredType)type;
        TypeElement element = (TypeElement)declared.asElement();
        ArrayList<CompletionItem> list = new ArrayList<CompletionItem>();
        for (Element element2 : task.task.getElements().getAllMembers(element)) {
            if (element2.getKind() != ElementKind.ENUM_CONSTANT || !StringSearch.matchesPartialName(element2.getSimpleName(), partial)) continue;
            list.add(this.item(task, element2));
        }
        return new CompletionList(false, list);
    }

    private CompletionList completeImport(String path) {
        LOG.info("...complete import");
        HashSet<String> names = new HashSet<String>();
        CompletionList list = new CompletionList();
        for (String className : this.compiler.publicTopLevelTypes()) {
            boolean isClass;
            String segment;
            if (!className.startsWith(path)) continue;
            int start = path.lastIndexOf(46);
            int end = className.indexOf(46, path.length());
            if (end == -1) {
                end = className.length();
            }
            if (names.contains(segment = className.substring(start + 1, end))) continue;
            names.add(segment);
            boolean bl = isClass = end == path.length();
            if (isClass) {
                list.items.add(this.classItem(className));
            } else {
                list.items.add(this.packageItem(segment));
            }
            if (list.items.size() <= 50) continue;
            list.isIncomplete = true;
            return list;
        }
        return list;
    }

    private CompletionItem packageItem(String name) {
        CompletionItem i = new CompletionItem();
        i.label = name;
        i.kind = 9;
        return i;
    }

    private CompletionItem classItem(String className) {
        CompletionItem i = new CompletionItem();
        i.label = this.simpleName(className).toString();
        i.kind = 7;
        i.detail = className;
        CompletionData data = new CompletionData();
        data.className = className;
        i.data = JsonHelper.GSON.toJsonTree((Object)data);
        return i;
    }

    private CompletionItem snippetItem(String label, String snippet) {
        CompletionItem i = new CompletionItem();
        i.label = label;
        i.kind = 15;
        i.insertText = snippet;
        i.insertTextFormat = 2;
        i.sortText = String.format("%02d%s", Priority.SNIPPET, i.label);
        return i;
    }

    private CompletionItem item(CompileTask task, Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            throw new RuntimeException("method");
        }
        CompletionItem i = new CompletionItem();
        i.label = element.getSimpleName().toString();
        i.kind = this.kind(element);
        i.detail = element.toString();
        i.data = JsonHelper.GSON.toJsonTree((Object)this.data(task, element, 1));
        return i;
    }

    private CompletionItem method(CompileTask task, List<ExecutableElement> overloads, boolean addParens) {
        ExecutableElement first = overloads.get(0);
        CompletionItem i = new CompletionItem();
        i.label = first.getSimpleName().toString();
        i.kind = 2;
        i.detail = String.valueOf(first.getReturnType()) + " " + String.valueOf(first);
        CompletionData data = this.data(task, first, overloads.size());
        i.data = JsonHelper.GSON.toJsonTree((Object)data);
        if (addParens) {
            if (overloads.size() == 1 && first.getParameters().isEmpty()) {
                i.insertText = String.valueOf(first.getSimpleName()) + "()$0";
            } else {
                i.insertText = String.valueOf(first.getSimpleName()) + "($0)";
                i.command = new Command();
                i.command.command = "editor.action.triggerParameterHints";
                i.command.title = "Trigger Parameter Hints";
            }
            i.insertTextFormat = 2;
        }
        return i;
    }

    private CompletionData data(CompileTask task, Element element, int overloads) {
        CompletionData data = new CompletionData();
        if (element instanceof TypeElement) {
            TypeElement type = (TypeElement)element;
            data.className = type.getQualifiedName().toString();
        } else if (element.getKind() == ElementKind.FIELD) {
            VariableElement field = (VariableElement)element;
            TypeElement type = (TypeElement)field.getEnclosingElement();
            data.className = type.getQualifiedName().toString();
            data.memberName = field.getSimpleName().toString();
        } else if (element instanceof ExecutableElement) {
            Types types = task.task.getTypes();
            ExecutableElement method = (ExecutableElement)element;
            TypeElement type = (TypeElement)method.getEnclosingElement();
            data.className = type.getQualifiedName().toString();
            data.memberName = method.getSimpleName().toString();
            data.erasedParameterTypes = new String[method.getParameters().size()];
            for (int i = 0; i < data.erasedParameterTypes.length; ++i) {
                TypeMirror p = method.getParameters().get(i).asType();
                data.erasedParameterTypes[i] = types.erasure(p).toString();
            }
            data.plusOverloads = overloads - 1;
        } else {
            return null;
        }
        return data;
    }

    private Integer kind(Element e) {
        switch (e.getKind()) {
            case ANNOTATION_TYPE: {
                return 8;
            }
            case CLASS: {
                return 7;
            }
            case CONSTRUCTOR: {
                return 4;
            }
            case ENUM: {
                return 13;
            }
            case ENUM_CONSTANT: {
                return 20;
            }
            case EXCEPTION_PARAMETER: {
                return 10;
            }
            case FIELD: {
                return 5;
            }
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                return 3;
            }
            case INTERFACE: {
                return 8;
            }
            case LOCAL_VARIABLE: {
                return 6;
            }
            case METHOD: {
                return 2;
            }
            case PACKAGE: {
                return 9;
            }
            case PARAMETER: {
                return 10;
            }
            case RESOURCE_VARIABLE: {
                return 6;
            }
            case TYPE_PARAMETER: {
                return 25;
            }
        }
        return null;
    }

    private CompletionItem keyword(String keyword) {
        CompletionItem i = new CompletionItem();
        i.label = keyword;
        i.kind = 14;
        i.detail = "keyword";
        i.sortText = String.format("%02d%s", Priority.KEYWORD, i.label);
        return i;
    }

    private void logCompletionTiming(Instant started, List<?> list, boolean isIncomplete) {
        long elapsedMs = Duration.between(started, Instant.now()).toMillis();
        if (isIncomplete) {
            LOG.info(String.format("Found %d items (incomplete) in %,d ms", list.size(), elapsedMs));
        } else {
            LOG.info(String.format("...found %d items in %,d ms", list.size(), elapsedMs));
        }
    }

    private CharSequence simpleName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return className;
        }
        return className.subSequence(dot + 1, className.length());
    }

    private static class Priority {
        static int iota;
        static final int SNIPPET;
        static final int LOCAL;
        static final int FIELD;
        static final int INHERITED_FIELD;
        static final int METHOD;
        static final int INHERITED_METHOD;
        static final int OBJECT_METHOD;
        static final int INNER_CLASS;
        static final int INHERITED_INNER_CLASS;
        static final int IMPORTED_CLASS;
        static final int NOT_IMPORTED_CLASS;
        static final int KEYWORD;
        static final int PACKAGE_MEMBER;
        static final int CASE_LABEL;

        private Priority() {
        }

        static {
            SNIPPET = iota = 0;
            LOCAL = iota++;
            FIELD = iota++;
            INHERITED_FIELD = iota++;
            METHOD = iota++;
            INHERITED_METHOD = iota++;
            OBJECT_METHOD = iota++;
            INNER_CLASS = iota++;
            INHERITED_INNER_CLASS = iota++;
            IMPORTED_CLASS = iota++;
            NOT_IMPORTED_CLASS = iota++;
            KEYWORD = iota++;
            PACKAGE_MEMBER = iota++;
            CASE_LABEL = iota++;
        }
    }
}

