/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.completion;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;

class FindCompletionsAt
extends TreePathScanner<TreePath, Long> {
    private final JavacTask task;
    private CompilationUnitTree root;

    FindCompletionsAt(JavacTask task) {
        this.task = task;
    }

    @Override
    public TreePath visitCompilationUnit(CompilationUnitTree t, Long find) {
        this.root = t;
        return this.reduce((TreePath)super.visitCompilationUnit(t, find), this.getCurrentPath());
    }

    @Override
    public TreePath visitIdentifier(IdentifierTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getStartPosition(this.root, t);
        long end = pos.getEndPosition(this.root, t);
        if (start <= find && find <= end) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitIdentifier(t, find);
    }

    @Override
    public TreePath visitMemberSelect(MemberSelectTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getEndPosition(this.root, t.getExpression()) + 1L;
        long end = pos.getEndPosition(this.root, t);
        if (start <= find && find <= end) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitMemberSelect(t, find);
    }

    @Override
    public TreePath visitMemberReference(MemberReferenceTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getEndPosition(this.root, t.getQualifierExpression()) + 2L;
        long end = pos.getEndPosition(this.root, t);
        if (start <= find && find <= end) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitMemberReference(t, find);
    }

    @Override
    public TreePath visitCase(CaseTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getStartPosition(this.root, t) + (long)"case".length();
        long end = pos.getEndPosition(this.root, t.getExpression());
        if (start <= find && find <= end) {
            return this.getCurrentPath().getParentPath();
        }
        return (TreePath)super.visitCase(t, find);
    }

    @Override
    public TreePath visitImport(ImportTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getStartPosition(this.root, t.getQualifiedIdentifier());
        long end = pos.getEndPosition(this.root, t.getQualifiedIdentifier());
        if (start <= find && find <= end) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitImport(t, find);
    }

    @Override
    public TreePath visitErroneous(ErroneousTree t, Long find) {
        if (t.getErrorTrees() == null) {
            return null;
        }
        for (Tree tree : t.getErrorTrees()) {
            TreePath found = (TreePath)this.scan(tree, find);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public TreePath reduce(TreePath a, TreePath b) {
        if (a != null) {
            return a;
        }
        return b;
    }
}

