/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.completion;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;

class FindInvocationAt
extends TreePathScanner<TreePath, Long> {
    private final JavacTask task;
    private CompilationUnitTree root;

    FindInvocationAt(JavacTask task) {
        this.task = task;
    }

    @Override
    public TreePath visitCompilationUnit(CompilationUnitTree t, Long find) {
        this.root = t;
        return this.reduce((TreePath)super.visitCompilationUnit(t, find), this.getCurrentPath());
    }

    @Override
    public TreePath visitMethodInvocation(MethodInvocationTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getEndPosition(this.root, t.getMethodSelect()) + 1L;
        long end = pos.getEndPosition(this.root, t) - 1L;
        if (start <= find && find <= end) {
            return this.reduce((TreePath)super.visitMethodInvocation(t, find), this.getCurrentPath());
        }
        return (TreePath)super.visitMethodInvocation(t, find);
    }

    @Override
    public TreePath visitNewClass(NewClassTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getEndPosition(this.root, t.getIdentifier()) + 1L;
        long end = pos.getEndPosition(this.root, t) - 1L;
        if (start <= find && find <= end) {
            return this.reduce((TreePath)super.visitNewClass(t, find), this.getCurrentPath());
        }
        return (TreePath)super.visitNewClass(t, find);
    }

    @Override
    public TreePath reduce(TreePath a, TreePath b) {
        if (a != null) {
            return a;
        }
        return b;
    }
}

