/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.completion;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.io.IOException;

public class PruneMethodBodies
extends TreeScanner<StringBuilder, Long> {
    private final JavacTask task;
    private final StringBuilder buf = new StringBuilder();
    private CompilationUnitTree root;

    public PruneMethodBodies(JavacTask task) {
        this.task = task;
    }

    @Override
    public StringBuilder visitCompilationUnit(CompilationUnitTree t, Long find) {
        this.root = t;
        try {
            CharSequence contents = t.getSourceFile().getCharContent(true);
            this.buf.setLength(0);
            this.buf.append(contents);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.visitCompilationUnit(t, find);
        return this.buf;
    }

    @Override
    public StringBuilder visitMethod(MethodTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        if (t.getBody() == null) {
            return this.buf;
        }
        long start = pos.getStartPosition(this.root, t.getBody());
        long end = pos.getEndPosition(this.root, t.getBody());
        if (start > find || find >= end) {
            int i = (int)start + 1;
            while ((long)i < end - 1L) {
                if (!Character.isWhitespace(this.buf.charAt(i))) {
                    this.buf.setCharAt(i, ' ');
                }
                ++i;
            }
            return this.buf;
        }
        super.visitMethod(t, find);
        return this.buf;
    }

    @Override
    public StringBuilder reduce(StringBuilder a, StringBuilder b) {
        return this.buf;
    }
}

