/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.completion;

import com.sun.source.tree.Scope;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import org.javacs.CompileTask;

class ScopeHelper {
    ScopeHelper() {
    }

    static List<Scope> fastScopes(Scope start) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (Scope s = start; s != null; s = s.getEnclosingScope()) {
            scopes.add(s);
        }
        return scopes.subList(0, scopes.size() - 2);
    }

    static List<Element> scopeMembers(CompileTask task, Scope inner, Predicate<CharSequence> filter) {
        Trees trees = Trees.instance(task.task);
        Elements elements = task.task.getElements();
        boolean isStatic = false;
        ArrayList<Element> list = new ArrayList<Element>();
        for (Scope scope : ScopeHelper.fastScopes(inner)) {
            if (scope.getEnclosingMethod() != null) {
                isStatic = isStatic || scope.getEnclosingMethod().getModifiers().contains((Object)Modifier.STATIC);
            }
            for (Element element : scope.getLocalElements()) {
                if (!filter.test(element.getSimpleName()) || isStatic && element.getSimpleName().contentEquals("this") || isStatic && element.getSimpleName().contentEquals("super")) continue;
                list.add(element);
            }
            if (scope.getEnclosingClass() == null) continue;
            TypeElement typeElement = scope.getEnclosingClass();
            DeclaredType declaredType = (DeclaredType)typeElement.asType();
            for (Element element : elements.getAllMembers(typeElement)) {
                if (!filter.test(element.getSimpleName()) || !trees.isAccessible(scope, element, declaredType) || isStatic && !element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                list.add(element);
            }
            isStatic = isStatic || typeElement.getModifiers().contains((Object)Modifier.STATIC);
        }
        return list;
    }
}

