/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.debug;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.StepRequest;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.javacs.LogFormat;
import org.javacs.debug.proto.AttachRequestArguments;
import org.javacs.debug.proto.Breakpoint;
import org.javacs.debug.proto.BreakpointEventBody;
import org.javacs.debug.proto.Capabilities;
import org.javacs.debug.proto.ContinueArguments;
import org.javacs.debug.proto.DebugClient;
import org.javacs.debug.proto.DebugServer;
import org.javacs.debug.proto.DisconnectArguments;
import org.javacs.debug.proto.EvaluateArguments;
import org.javacs.debug.proto.EvaluateResponseBody;
import org.javacs.debug.proto.ExitedEventBody;
import org.javacs.debug.proto.InitializeRequestArguments;
import org.javacs.debug.proto.LaunchRequestArguments;
import org.javacs.debug.proto.NextArguments;
import org.javacs.debug.proto.OutputEventBody;
import org.javacs.debug.proto.Scope;
import org.javacs.debug.proto.ScopesArguments;
import org.javacs.debug.proto.ScopesResponseBody;
import org.javacs.debug.proto.SetBreakpointsArguments;
import org.javacs.debug.proto.SetBreakpointsResponseBody;
import org.javacs.debug.proto.SetExceptionBreakpointsArguments;
import org.javacs.debug.proto.SetFunctionBreakpointsArguments;
import org.javacs.debug.proto.SetFunctionBreakpointsResponseBody;
import org.javacs.debug.proto.Source;
import org.javacs.debug.proto.SourceBreakpoint;
import org.javacs.debug.proto.StackFrame;
import org.javacs.debug.proto.StackTraceArguments;
import org.javacs.debug.proto.StackTraceResponseBody;
import org.javacs.debug.proto.StepInArguments;
import org.javacs.debug.proto.StepOutArguments;
import org.javacs.debug.proto.StoppedEventBody;
import org.javacs.debug.proto.TerminateArguments;
import org.javacs.debug.proto.TerminatedEventBody;
import org.javacs.debug.proto.Thread;
import org.javacs.debug.proto.ThreadsResponseBody;
import org.javacs.debug.proto.Variable;
import org.javacs.debug.proto.VariablesArguments;
import org.javacs.debug.proto.VariablesResponseBody;

public class JavaDebugServer
implements DebugServer {
    private final DebugClient client;
    private List<Path> sourceRoots = List.of();
    private VirtualMachine vm;
    private final List<Breakpoint> pendingBreakpoints = new ArrayList<Breakpoint>();
    private static int breakPointCounter = 0;
    private static final Set<String> warnedCouldNotFind = new HashSet<String>();
    private static final int FRAME_OFFSET = 100;
    private static final Logger LOG = Logger.getLogger("debug");

    public JavaDebugServer(final DebugClient client) {
        this.client = client;
        class LogToConsole
        extends Handler {
            private final LogFormat format = new LogFormat();

            LogToConsole() {
            }

            @Override
            public void publish(LogRecord r) {
                OutputEventBody evt = new OutputEventBody();
                evt.category = "console";
                evt.output = this.format.format(r);
                client.output(evt);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        }
        Logger.getLogger("debug").addHandler(new LogToConsole());
    }

    @Override
    public Capabilities initialize(InitializeRequestArguments req) {
        Capabilities resp = new Capabilities();
        resp.supportsConfigurationDoneRequest = true;
        return resp;
    }

    @Override
    public SetBreakpointsResponseBody setBreakpoints(SetBreakpointsArguments req) {
        LOG.info("Received " + req.breakpoints.length + " breakpoints in " + req.source.path);
        this.disableBreakpoints(req.source);
        SetBreakpointsResponseBody resp = new SetBreakpointsResponseBody();
        resp.breakpoints = new Breakpoint[req.breakpoints.length];
        for (int i = 0; i < req.breakpoints.length; ++i) {
            resp.breakpoints[i] = this.enableBreakpoint(req.source, req.breakpoints[i]);
        }
        return resp;
    }

    private void disableBreakpoints(Source source) {
        for (BreakpointRequest b : this.vm.eventRequestManager().breakpointRequests()) {
            if (!this.matchesFile(b, source)) continue;
            LOG.info(String.format("Disable breakpoint %s:%d", source.path, b.location().lineNumber()));
            b.disable();
        }
    }

    private Breakpoint enableBreakpoint(Source source, SourceBreakpoint b) {
        for (BreakpointRequest req : this.vm.eventRequestManager().breakpointRequests()) {
            if (!this.matchesFile(req, source) || !this.matchesLine(req, b.line)) continue;
            return this.enableDisabledBreakpoint(source, req);
        }
        Iterator<Mirror> iterator = this.loadedTypesMatching(source.path).iterator();
        if (iterator.hasNext()) {
            ReferenceType type = (ReferenceType)iterator.next();
            return this.enableBreakpointImmediately(source, b, type);
        }
        return this.enableBreakpointLater(source, b);
    }

    private boolean matchesFile(BreakpointRequest b, Source source) {
        try {
            String relativePath = b.location().sourcePath(this.vm.getDefaultStratum());
            return source.path.endsWith(relativePath);
        }
        catch (AbsentInformationException __) {
            LOG.warning("No source information for " + String.valueOf(b.location()));
            return false;
        }
    }

    private boolean matchesLine(BreakpointRequest b, int line) {
        return line == b.location().lineNumber(this.vm.getDefaultStratum());
    }

    private List<ReferenceType> loadedTypesMatching(String absolutePath) {
        ArrayList<ReferenceType> matches = new ArrayList<ReferenceType>();
        for (ReferenceType type : this.vm.allClasses()) {
            String path = this.relativePath(type);
            if (path.isEmpty() || !absolutePath.endsWith(path)) continue;
            matches.add(type);
        }
        return matches;
    }

    private Breakpoint enableDisabledBreakpoint(Source source, BreakpointRequest b) {
        LOG.info(String.format("Enable disabled breakpoint %s:%d", source.path, b.location().lineNumber()));
        b.enable();
        Breakpoint ok = new Breakpoint();
        ok.verified = true;
        ok.source = source;
        ok.line = b.location().lineNumber(this.vm.getDefaultStratum());
        return ok;
    }

    private Breakpoint enableBreakpointImmediately(Source source, SourceBreakpoint b, ReferenceType type) {
        if (!this.tryEnableBreakpointImmediately(source, b, type)) {
            Breakpoint failed = new Breakpoint();
            failed.verified = false;
            failed.message = source.name + ":" + b.line + " could not be found or had no code on it";
            return failed;
        }
        Breakpoint ok = new Breakpoint();
        ok.verified = true;
        ok.source = source;
        ok.line = b.line;
        return ok;
    }

    private boolean tryEnableBreakpointImmediately(Source source, SourceBreakpoint b, ReferenceType type) {
        List<Location> locations;
        try {
            locations = type.locationsOfLine(b.line);
        }
        catch (AbsentInformationException __) {
            LOG.info(String.format("No locations in %s for breakpoint %s:%d", type.name(), source.path, b.line));
            return false;
        }
        for (Location l : locations) {
            LOG.info(String.format("Create breakpoint %s:%d", source.path, l.lineNumber()));
            BreakpointRequest req = this.vm.eventRequestManager().createBreakpointRequest(l);
            req.setSuspendPolicy(2);
            req.enable();
        }
        return true;
    }

    private Breakpoint enableBreakpointLater(Source source, SourceBreakpoint b) {
        LOG.info(String.format("Enable %s:%d later", source.path, b.line));
        Breakpoint pending = new Breakpoint();
        pending.id = breakPointCounter++;
        pending.source = new Source();
        pending.source.path = source.path;
        pending.line = b.line;
        pending.column = b.column;
        pending.verified = false;
        pending.message = source.name + " is not yet loaded";
        this.pendingBreakpoints.add(pending);
        return pending;
    }

    @Override
    public SetFunctionBreakpointsResponseBody setFunctionBreakpoints(SetFunctionBreakpointsArguments req) {
        LOG.warning("Not yet implemented");
        return new SetFunctionBreakpointsResponseBody();
    }

    @Override
    public void setExceptionBreakpoints(SetExceptionBreakpointsArguments req) {
        LOG.warning("Not yet implemented");
    }

    @Override
    public void configurationDone() {
        this.listenForClassPrepareEvents();
        this.enablePendingBreakpointsInLoadedClasses();
        this.vm.resume();
    }

    private void listenForClassPrepareEvents() {
        Objects.requireNonNull(this.vm, "vm has not been initialized");
        HashSet<String> distinctSourceNames = new HashSet<String>();
        for (Breakpoint b : this.pendingBreakpoints) {
            Path path = Paths.get(b.source.path, new String[0]);
            Path name = path.getFileName();
            distinctSourceNames.add(name.toString());
        }
        for (String name : distinctSourceNames) {
            LOG.info("Listen for ClassPrepareRequest in " + name);
            ClassPrepareRequest requestClassEvent = this.vm.eventRequestManager().createClassPrepareRequest();
            requestClassEvent.addSourceNameFilter("*" + name);
            requestClassEvent.setSuspendPolicy(2);
            requestClassEvent.enable();
        }
    }

    @Override
    public void launch(LaunchRequestArguments req) {
        throw new UnsupportedOperationException();
    }

    private static AttachingConnector connector(String transport) {
        ArrayList<String> found = new ArrayList<String>();
        for (AttachingConnector conn : Bootstrap.virtualMachineManager().attachingConnectors()) {
            if (conn.transport().name().equals(transport)) {
                return conn;
            }
            found.add(conn.transport().name());
        }
        throw new RuntimeException("Couldn't find connector for transport " + transport + " in " + String.valueOf(found));
    }

    @Override
    public void attach(AttachRequestArguments req) {
        this.sourceRoots = new ArrayList<Path>();
        for (String string : req.sourceRoots) {
            Path path = Paths.get(string, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                LOG.warning(string + " does not exist");
                continue;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                LOG.warning(string + " is not a directory");
                continue;
            }
            LOG.info(String.valueOf(path) + " is a source root");
            this.sourceRoots.add(path);
        }
        if (!this.tryToConnect(req.port)) {
            throw new RuntimeException("Failed to connect after 15 attempts");
        }
        java.lang.Thread reader = new java.lang.Thread((Runnable)new ReceiveVmEvents(), "receive-vm");
        reader.setDaemon(true);
        reader.start();
        this.client.initialized();
    }

    private boolean tryToConnect(int port) {
        AttachingConnector conn = JavaDebugServer.connector("dt_socket");
        Map<String, Connector.Argument> args = conn.defaultArguments();
        int intervalMs = 500;
        int tryForS = 15;
        int attempts = tryForS * 1000 / intervalMs;
        args.get("port").setValue(Integer.toString(port));
        for (int attempt = 0; attempt < attempts; ++attempt) {
            try {
                this.vm = conn.attach(args);
                return true;
            }
            catch (ConnectException e) {
                LOG.warning(e.getMessage());
                try {
                    java.lang.Thread.sleep(intervalMs);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (IllegalConnectorArgumentsException | IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void enablePendingBreakpointsInLoadedClasses() {
        Objects.requireNonNull(this.vm, "vm has not been initialized");
        for (ReferenceType type : this.vm.allClasses()) {
            this.enablePendingBreakpointsIn(type);
        }
    }

    private void enablePendingBreakpointsIn(ReferenceType type) {
        String path = this.relativePath(type);
        if (path.isEmpty()) {
            return;
        }
        ArrayList<Breakpoint> enabled = new ArrayList<Breakpoint>();
        for (Breakpoint b : this.pendingBreakpoints) {
            if (!b.source.path.endsWith(path)) continue;
            this.enablePendingBreakpoint(b, type);
            enabled.add(b);
        }
        this.pendingBreakpoints.removeAll(enabled);
    }

    private void enablePendingBreakpoint(Breakpoint b, ReferenceType type) {
        try {
            List<Location> locations = type.locationsOfLine(b.line);
            for (Location line : locations) {
                BreakpointRequest req = this.vm.eventRequestManager().createBreakpointRequest(line);
                req.setSuspendPolicy(2);
                req.enable();
            }
            if (locations.isEmpty()) {
                LOG.info("No locations at " + b.source.path + ":" + b.line);
                BreakpointEventBody failed = new BreakpointEventBody();
                failed.reason = "changed";
                failed.breakpoint = b;
                b.verified = false;
                b.message = b.source.name + ":" + b.line + " could not be found or had no code on it";
                this.client.breakpoint(failed);
                return;
            }
            LOG.info("Enable breakpoint at " + b.source.path + ":" + b.line);
            BreakpointEventBody ok = new BreakpointEventBody();
            ok.reason = "changed";
            ok.breakpoint = b;
            b.verified = true;
            b.message = null;
            this.client.breakpoint(ok);
        }
        catch (AbsentInformationException __) {
            LOG.info("Absent information at " + b.source.path + ":" + b.line);
            BreakpointEventBody failed = new BreakpointEventBody();
            failed.reason = "changed";
            failed.breakpoint = b;
            b.verified = false;
            b.message = b.source.name + ":" + b.line + " could not be found or had no code on it";
            this.client.breakpoint(failed);
        }
    }

    private String relativePath(ReferenceType type) {
        try {
            Iterator<String> iterator = type.sourcePaths(this.vm.getDefaultStratum()).iterator();
            if (iterator.hasNext()) {
                String path = iterator.next();
                return path;
            }
            return "";
        }
        catch (AbsentInformationException __) {
            return "";
        }
    }

    @Override
    public void disconnect(DisconnectArguments req) {
        try {
            this.vm.dispose();
        }
        catch (VMDisconnectedException __) {
            LOG.warning("VM has already terminated");
        }
        this.vm = null;
    }

    @Override
    public void terminate(TerminateArguments req) {
        this.vm.exit(1);
    }

    @Override
    public void continue_(ContinueArguments req) {
        this.vm.resume();
    }

    @Override
    public void next(NextArguments req) {
        ThreadReference thread = this.findThread(req.threadId);
        if (thread == null) {
            LOG.warning("No thread with id " + req.threadId);
            return;
        }
        LOG.info("Send StepRequest(STEP_LINE, STEP_OVER) to VM and resume");
        StepRequest step = this.vm.eventRequestManager().createStepRequest(thread, -2, 2);
        step.addCountFilter(1);
        step.enable();
        this.vm.resume();
    }

    @Override
    public void stepIn(StepInArguments req) {
        ThreadReference thread = this.findThread(req.threadId);
        if (thread == null) {
            LOG.warning("No thread with id " + req.threadId);
            return;
        }
        LOG.info("Send StepRequest(STEP_LINE, STEP_INTO) to VM and resume");
        StepRequest step = this.vm.eventRequestManager().createStepRequest(thread, -2, 1);
        step.addCountFilter(1);
        step.enable();
        this.vm.resume();
    }

    @Override
    public void stepOut(StepOutArguments req) {
        ThreadReference thread = this.findThread(req.threadId);
        if (thread == null) {
            LOG.warning("No thread with id " + req.threadId);
            return;
        }
        LOG.info("Send StepRequest(STEP_LINE, STEP_OUT) to VM and resume");
        StepRequest step = this.vm.eventRequestManager().createStepRequest(thread, -2, 3);
        step.addCountFilter(1);
        step.enable();
        this.vm.resume();
    }

    @Override
    public ThreadsResponseBody threads() {
        ThreadsResponseBody threads = new ThreadsResponseBody();
        threads.threads = this.asThreads(this.vm.allThreads());
        return threads;
    }

    private Thread[] asThreads(List<ThreadReference> ts) {
        Thread[] result = new Thread[ts.size()];
        for (int i = 0; i < ts.size(); ++i) {
            result[i] = this.asThread(ts.get(i));
        }
        return result;
    }

    private Thread asThread(ThreadReference t) {
        Thread thread = new Thread();
        thread.id = t.uniqueID();
        thread.name = t.name();
        return thread;
    }

    private ThreadReference findThread(long threadId) {
        for (ThreadReference thread : this.vm.allThreads()) {
            if (thread.uniqueID() != threadId) continue;
            return thread;
        }
        return null;
    }

    @Override
    public StackTraceResponseBody stackTrace(StackTraceArguments req) {
        try {
            for (ThreadReference t : this.vm.allThreads()) {
                if (t.uniqueID() != req.threadId) continue;
                int length = t.frameCount() - req.startFrame;
                if (req.levels != null && req.levels < length) {
                    length = req.levels;
                }
                StackTraceResponseBody resp = new StackTraceResponseBody();
                resp.stackFrames = this.asStackFrames(t.frames(req.startFrame, length));
                resp.totalFrames = t.frameCount();
                return resp;
            }
            throw new RuntimeException("Couldn't find thread " + req.threadId);
        }
        catch (IncompatibleThreadStateException e) {
            throw new RuntimeException(e);
        }
    }

    private StackFrame[] asStackFrames(List<com.sun.jdi.StackFrame> fs) {
        StackFrame[] result = new StackFrame[fs.size()];
        for (int i = 0; i < fs.size(); ++i) {
            result[i] = this.asStackFrame(fs.get(i));
        }
        return result;
    }

    private StackFrame asStackFrame(com.sun.jdi.StackFrame f) {
        StackFrame frame = new StackFrame();
        frame.id = this.uniqueFrameId(f);
        frame.name = f.location().method().name();
        frame.source = this.asSource(f.location());
        frame.line = f.location().lineNumber();
        return frame;
    }

    private Source asSource(Location l) {
        try {
            Path path = this.findSource(l);
            Source src = new Source();
            src.name = l.sourceName();
            src.path = Objects.toString(path, null);
            return src;
        }
        catch (AbsentInformationException __) {
            Source src = new Source();
            src.path = this.relativePath(l.declaringType());
            src.name = l.declaringType().name();
            src.presentationHint = "deemphasize";
            return src;
        }
    }

    private Path findSource(Location l) throws AbsentInformationException {
        String relative = l.sourcePath();
        for (Path root : this.sourceRoots) {
            Path absolute = root.resolve(relative);
            if (!Files.exists(absolute, new LinkOption[0])) continue;
            return absolute;
        }
        if (!warnedCouldNotFind.contains(relative)) {
            LOG.warning("Could not find " + relative);
            warnedCouldNotFind.add(relative);
        }
        return null;
    }

    private long uniqueFrameId(com.sun.jdi.StackFrame f) {
        try {
            long count = 100L;
            for (ThreadReference thread : f.virtualMachine().allThreads()) {
                if (thread.equals(f.thread())) {
                    for (com.sun.jdi.StackFrame frame : thread.frames()) {
                        if (frame.equals(f)) {
                            return count;
                        }
                        ++count;
                    }
                    continue;
                }
                count += (long)thread.frameCount();
            }
            return count;
        }
        catch (IncompatibleThreadStateException e) {
            throw new RuntimeException(e);
        }
    }

    private com.sun.jdi.StackFrame findFrame(long id) {
        try {
            long count = 100L;
            for (ThreadReference thread : this.vm.allThreads()) {
                if (id < count + (long)thread.frameCount()) {
                    int offset = (int)(id - count);
                    return thread.frame(offset);
                }
                count += (long)thread.frameCount();
            }
            throw new RuntimeException("Couldn't find frame " + id);
        }
        catch (IncompatibleThreadStateException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ScopesResponseBody scopes(ScopesArguments req) {
        ScopesResponseBody resp = new ScopesResponseBody();
        Scope locals = new Scope();
        locals.name = "Locals";
        locals.presentationHint = "locals";
        locals.variablesReference = req.frameId * 2L;
        Scope arguments = new Scope();
        arguments.name = "Arguments";
        arguments.presentationHint = "arguments";
        arguments.variablesReference = req.frameId * 2L + 1L;
        resp.scopes = new Scope[]{locals, arguments};
        return resp;
    }

    @Override
    public VariablesResponseBody variables(VariablesArguments req) {
        List<LocalVariable> visible;
        long frameId = req.variablesReference / 2L;
        int scopeId = (int)(req.variablesReference % 2L);
        boolean argumentScope = scopeId == 1;
        com.sun.jdi.StackFrame frame = this.findFrame(frameId);
        try {
            visible = frame.visibleVariables();
        }
        catch (AbsentInformationException __) {
            LOG.warning(String.format("No visible variable information in %s", frame.location()));
            return new VariablesResponseBody();
        }
        Map<LocalVariable, Value> values = frame.getValues(visible);
        ThreadReference thread = frame.thread();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (LocalVariable v : visible) {
            if (v.isArgument() != argumentScope) continue;
            Variable w = new Variable();
            w.name = v.name();
            w.value = this.print(values.get(v), thread);
            w.type = v.typeName();
            variables.add(w);
        }
        VariablesResponseBody resp = new VariablesResponseBody();
        resp.variables = (Variable[])variables.toArray(Variable[]::new);
        return resp;
    }

    private String print(Value value, ThreadReference t) {
        if (value == null) {
            return "null";
        }
        if (value instanceof ObjectReference) {
            return this.printObject((ObjectReference)value, t);
        }
        return value.toString();
    }

    private String printObject(ObjectReference object, ThreadReference t) {
        ReferenceType type = object.referenceType();
        Iterator<Method> iterator = type.methodsByName("toString", "()Ljava/lang/String;").iterator();
        if (iterator.hasNext()) {
            Method method = iterator.next();
            try {
                StringReference string = (StringReference)object.invokeMethod(t, method, List.of(), 0);
                return string.value();
            }
            catch (InvocationException e) {
                return String.format("toString() threw %s", e.exception().type().name());
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException e) {
                throw new RuntimeException(e);
            }
        }
        return object.toString();
    }

    @Override
    public EvaluateResponseBody evaluate(EvaluateArguments req) {
        throw new UnsupportedOperationException();
    }

    class ReceiveVmEvents
    implements Runnable {
        ReceiveVmEvents() {
        }

        @Override
        public void run() {
            EventQueue events = JavaDebugServer.this.vm.eventQueue();
            try {
                block3: while (true) {
                    EventSet nextSet = events.remove();
                    Iterator iterator = nextSet.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        Event event = (Event)iterator.next();
                        this.process(event);
                    }
                    break;
                }
            }
            catch (VMDisconnectedException __) {
                LOG.info("VM disconnected");
                return;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                return;
            }
        }

        private void process(Event event) {
            LOG.info("Received " + event.toString() + " from VM");
            if (event instanceof ClassPrepareEvent) {
                ClassPrepareEvent prepare = (ClassPrepareEvent)event;
                ReferenceType type = prepare.referenceType();
                LOG.info("ClassPrepareRequest for class " + type.name() + " in source " + JavaDebugServer.this.relativePath(type));
                JavaDebugServer.this.enablePendingBreakpointsIn(type);
                JavaDebugServer.this.vm.resume();
            } else if (event instanceof BreakpointEvent) {
                BreakpointEvent b = (BreakpointEvent)event;
                StoppedEventBody evt = new StoppedEventBody();
                evt.reason = "breakpoint";
                evt.threadId = b.thread().uniqueID();
                evt.allThreadsStopped = b.request().suspendPolicy() == 2;
                JavaDebugServer.this.client.stopped(evt);
            } else if (event instanceof StepEvent) {
                StepEvent b = (StepEvent)event;
                StoppedEventBody evt = new StoppedEventBody();
                evt.reason = "step";
                evt.threadId = b.thread().uniqueID();
                evt.allThreadsStopped = b.request().suspendPolicy() == 2;
                JavaDebugServer.this.client.stopped(evt);
                event.request().disable();
            } else if (event instanceof VMDeathEvent) {
                JavaDebugServer.this.client.exited(new ExitedEventBody());
            } else if (event instanceof VMDisconnectEvent) {
                JavaDebugServer.this.client.terminated(new TerminatedEventBody());
            }
        }
    }
}

