/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.fold;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LineMap;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.javacs.CompilerProvider;
import org.javacs.ParseTask;
import org.javacs.lsp.FoldingRange;

public class FoldProvider {
    final CompilerProvider compiler;

    public FoldProvider(CompilerProvider compiler) {
        this.compiler = compiler;
    }

    public List<FoldingRange> foldingRanges(Path file) {
        ParseTask task = this.compiler.parse(file);
        final ArrayList imports = new ArrayList();
        final ArrayList blocks = new ArrayList();
        ArrayList comments = new ArrayList();
        class FindFoldingRanges
        extends TreePathScanner<Void, Void> {
            FindFoldingRanges() {
            }

            @Override
            public Void visitClass(ClassTree t, Void __) {
                blocks.add(this.getCurrentPath());
                return (Void)super.visitClass(t, null);
            }

            @Override
            public Void visitBlock(BlockTree t, Void __) {
                blocks.add(this.getCurrentPath());
                return (Void)super.visitBlock(t, null);
            }

            @Override
            public Void visitImport(ImportTree t, Void __) {
                imports.add(this.getCurrentPath());
                return null;
            }
        }
        new FindFoldingRanges().scan(task.root, null);
        ArrayList<FoldingRange> all = new ArrayList<FoldingRange>();
        if (!imports.isEmpty()) {
            FoldingRange merged = this.asFoldingRange(task, (TreePath)imports.get(0), "imports");
            for (TreePath i : imports) {
                FoldingRange r = this.asFoldingRange(task, i, "imports");
                if (r.startLine <= merged.endLine + 1) {
                    merged = new FoldingRange(merged.startLine, merged.startCharacter, r.endLine, r.endCharacter, "imports");
                    continue;
                }
                all.add(merged);
                merged = r;
            }
            all.add(merged);
        }
        for (TreePath t : blocks) {
            all.add(this.asFoldingRange(task, t, "region"));
        }
        for (TreePath t : comments) {
            all.add(this.asFoldingRange(task, t, "region"));
        }
        return all;
    }

    private FoldingRange asFoldingRange(ParseTask task, TreePath t, String kind) {
        Trees trees = Trees.instance(task.task);
        SourcePositions pos = trees.getSourcePositions();
        LineMap lines = t.getCompilationUnit().getLineMap();
        int start = (int)pos.getStartPosition(t.getCompilationUnit(), t.getLeaf());
        int end = (int)pos.getEndPosition(t.getCompilationUnit(), t.getLeaf());
        if (t.getLeaf() instanceof ClassTree) {
            CharSequence content;
            try {
                content = t.getCompilationUnit().getSourceFile().getCharContent(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (int i = start; i < content.length(); ++i) {
                if (content.charAt(i) != '{') continue;
                start = i;
                break;
            }
        }
        int startLine = (int)lines.getLineNumber(start) - 1;
        int startChar = (int)lines.getColumnNumber(start) - 1;
        int endLine = (int)lines.getLineNumber(end) - 1;
        int endChar = (int)lines.getColumnNumber(end) - 1;
        if (t.getLeaf() instanceof ClassTree || t.getLeaf() instanceof BlockTree) {
            --endLine;
        }
        return new FoldingRange(startLine, startChar, endLine, endChar, kind);
    }
}

