/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.index;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.javacs.CompilerProvider;
import org.javacs.ParseTask;
import org.javacs.index.FindSymbolsMatching;
import org.javacs.lsp.SymbolInformation;

public class SymbolProvider {
    final CompilerProvider compiler;
    private static final Logger LOG = Logger.getLogger("main");

    public SymbolProvider(CompilerProvider compiler) {
        this.compiler = compiler;
    }

    public List<SymbolInformation> findSymbols(String query, int limit) {
        LOG.info(String.format("Searching for `%s`...", query));
        ArrayList<SymbolInformation> result = new ArrayList<SymbolInformation>();
        int checked = 0;
        int parsed = 0;
        for (Path file : this.compiler.search(query)) {
            ++checked;
            LOG.info(String.format("...%s contains text matches", file.getFileName()));
            ParseTask task = this.compiler.parse(file);
            List<SymbolInformation> symbols = this.findSymbolsMatching(task, query);
            ++parsed;
            if (symbols.size() > 0) {
                LOG.info(String.format("...found %d occurrences", symbols.size()));
            }
            result.addAll(symbols);
            if (result.size() < limit) continue;
            break;
        }
        return result;
    }

    public List<SymbolInformation> documentSymbols(Path file) {
        ParseTask task = this.compiler.parse(file);
        return this.findSymbolsMatching(task, "");
    }

    private List<SymbolInformation> findSymbolsMatching(ParseTask task, String query) {
        ArrayList<SymbolInformation> found = new ArrayList<SymbolInformation>();
        new FindSymbolsMatching(task, query).scan(task.root, found);
        return found;
    }
}

