/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.lens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Name;
import org.javacs.FileStore;
import org.javacs.lsp.CodeLens;
import org.javacs.lsp.Command;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;

class FindCodeLenses
extends TreeScanner<Void, List<CodeLens>> {
    private final JavacTask task;
    private CompilationUnitTree root;
    private List<CharSequence> qualifiedName = new ArrayList<CharSequence>();

    FindCodeLenses(JavacTask task) {
        this.task = task;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree t, List<CodeLens> list) {
        String name = Objects.toString(t.getPackageName(), "");
        this.qualifiedName.add(name);
        this.root = t;
        return (Void)super.visitCompilationUnit(t, list);
    }

    @Override
    public Void visitClass(ClassTree t, List<CodeLens> list) {
        this.qualifiedName.add(t.getSimpleName());
        if (this.isTestClass(t)) {
            list.add(this.runAllTests(t));
        }
        Void result = (Void)super.visitClass(t, list);
        this.qualifiedName.remove(this.qualifiedName.size() - 1);
        return result;
    }

    @Override
    public Void visitMethod(MethodTree t, List<CodeLens> list) {
        if (this.isTestMethod(t)) {
            list.add(this.runTest(t));
            list.add(this.debugTest(t));
        }
        return (Void)super.visitMethod(t, list);
    }

    private boolean isTestClass(ClassTree t) {
        for (Tree tree : t.getMembers()) {
            MethodTree method;
            if (!(tree instanceof MethodTree) || !this.isTestMethod(method = (MethodTree)tree)) continue;
            return true;
        }
        return false;
    }

    private boolean isTestMethod(MethodTree t) {
        for (AnnotationTree annotationTree : t.getModifiers().getAnnotations()) {
            IdentifierTree id;
            Name name;
            Tree type = annotationTree.getAnnotationType();
            if (!(type instanceof IdentifierTree) || !(name = (id = (IdentifierTree)type).getName()).contentEquals("Test") && !name.contentEquals("org.junit.Test")) continue;
            return true;
        }
        return false;
    }

    private CodeLens runAllTests(ClassTree t) {
        JsonArray arguments = new JsonArray();
        arguments.add(this.root.getSourceFile().toUri().toString());
        arguments.add(String.join((CharSequence)".", this.qualifiedName));
        arguments.add((JsonElement)JsonNull.INSTANCE);
        Command command = new Command("Run All Tests", "java.command.test.run", arguments);
        Range range = this.range(t);
        return new CodeLens(range, command, null);
    }

    private CodeLens runTest(MethodTree t) {
        JsonArray arguments = new JsonArray();
        arguments.add(this.root.getSourceFile().toUri().toString());
        arguments.add(String.join((CharSequence)".", this.qualifiedName));
        arguments.add(t.getName().toString());
        Command command = new Command("Run Test", "java.command.test.run", arguments);
        Range range = this.range(t);
        return new CodeLens(range, command, null);
    }

    private CodeLens debugTest(MethodTree t) {
        JsonArray arguments = new JsonArray();
        arguments.add(this.root.getSourceFile().toUri().toString());
        arguments.add(String.join((CharSequence)".", this.qualifiedName));
        arguments.add(t.getName().toString());
        JsonArray sourceRoots = new JsonArray();
        for (Path dir : FileStore.sourceRoots()) {
            sourceRoots.add(dir.toString());
        }
        arguments.add((JsonElement)sourceRoots);
        Command command = new Command("Debug Test", "java.command.test.debug", arguments);
        Range range = this.range(t);
        return new CodeLens(range, command, null);
    }

    private Range range(Tree t) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        LineMap lines = this.root.getLineMap();
        long start = pos.getStartPosition(this.root, t);
        long end = pos.getEndPosition(this.root, t);
        int startLine = (int)lines.getLineNumber(start);
        int startColumn = (int)lines.getColumnNumber(start);
        int endLine = (int)lines.getLineNumber(end);
        int endColumn = (int)lines.getColumnNumber(end);
        return new Range(new Position(startLine - 1, startColumn - 1), new Position(endLine - 1, endColumn - 1));
    }
}

