/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.lsp;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javacs.lsp.CancelParams;
import org.javacs.lsp.CodeActionParams;
import org.javacs.lsp.CodeLens;
import org.javacs.lsp.CodeLensParams;
import org.javacs.lsp.CompletionItem;
import org.javacs.lsp.DidChangeConfigurationParams;
import org.javacs.lsp.DidChangeTextDocumentParams;
import org.javacs.lsp.DidChangeWatchedFilesParams;
import org.javacs.lsp.DidChangeWorkspaceFoldersParams;
import org.javacs.lsp.DidCloseTextDocumentParams;
import org.javacs.lsp.DidOpenTextDocumentParams;
import org.javacs.lsp.DidSaveTextDocumentParams;
import org.javacs.lsp.DocumentFormattingParams;
import org.javacs.lsp.DocumentLinkParams;
import org.javacs.lsp.DocumentSymbolParams;
import org.javacs.lsp.FoldingRangeParams;
import org.javacs.lsp.InitializeParams;
import org.javacs.lsp.LanguageClient;
import org.javacs.lsp.LanguageServer;
import org.javacs.lsp.Message;
import org.javacs.lsp.PublishDiagnosticsParams;
import org.javacs.lsp.ReferenceParams;
import org.javacs.lsp.RegistrationParams;
import org.javacs.lsp.RenameParams;
import org.javacs.lsp.ResponseError;
import org.javacs.lsp.ShowMessageParams;
import org.javacs.lsp.TextDocumentPositionParams;
import org.javacs.lsp.WillSaveTextDocumentParams;
import org.javacs.lsp.WorkspaceSymbolParams;

public class LSP {
    private static final Gson gson = new Gson();
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final Logger LOG = Logger.getLogger("main");

    private static String readHeader(InputStream client) {
        StringBuilder line = new StringBuilder();
        char next = LSP.read(client);
        while (true) {
            if (next == '\r') {
                char last = LSP.read(client);
                assert (last == '\n');
                break;
            }
            line.append(next);
            next = LSP.read(client);
        }
        return line.toString();
    }

    private static int parseHeader(String header) {
        String contentLength = "Content-Length: ";
        if (header.startsWith(contentLength)) {
            String tail = header.substring(contentLength.length());
            int length = Integer.parseInt(tail);
            return length;
        }
        return -1;
    }

    private static char read(InputStream client) {
        try {
            int c = client.read();
            if (c == -1) {
                LOG.warning("Stream from client has been closed, throwing kill exception...");
                throw new EndOfStream();
            }
            return (char)c;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new EndOfStream();
        }
    }

    private static String readLength(InputStream client, int byteLength) {
        try {
            return new String(client.readNBytes(byteLength), StandardCharsets.UTF_8).stripLeading();
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred during the reading of client data", e);
        }
    }

    static String nextToken(InputStream client) {
        int contentLength = -1;
        String line;
        while (!(line = LSP.readHeader(client)).isEmpty()) {
            int maybeLength = LSP.parseHeader(line);
            if (maybeLength == -1) continue;
            contentLength = maybeLength;
        }
        return LSP.readLength(client, contentLength);
    }

    static Message parseMessage(String token) {
        return (Message)gson.fromJson(token, Message.class);
    }

    private static void writeClient(OutputStream client, String messageText) {
        byte[] messageBytes = messageText.getBytes(UTF_8);
        String headerText = String.format("Content-Length: %d\r\n\r\n", messageBytes.length);
        byte[] headerBytes = headerText.getBytes(UTF_8);
        try {
            client.write(headerBytes);
            client.write(messageBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String toJson(Object message) {
        return gson.toJson(message);
    }

    static void respond(OutputStream client, int requestId, Object params) {
        if (params instanceof ResponseError) {
            throw new RuntimeException("Errors should be sent using LSP.error(...)");
        }
        if (params instanceof Optional) {
            Optional option = (Optional)params;
            params = option.orElse(null);
        }
        String jsonText = LSP.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"result\":%s}", requestId, jsonText);
        LSP.writeClient(client, messageText);
    }

    static void error(OutputStream client, int requestId, ResponseError error) {
        String jsonText = LSP.toJson(error);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"error\":%s}", requestId, jsonText);
        LSP.writeClient(client, messageText);
    }

    private static void notifyClient(OutputStream client, String method, Object params) {
        if (params instanceof Optional) {
            Optional option = (Optional)params;
            params = option.orElse(null);
        }
        String jsonText = LSP.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"method\":\"%s\",\"params\":%s}", method, jsonText);
        LSP.writeClient(client, messageText);
    }

    public static void connect(Function<LanguageClient, LanguageServer> serverFactory, final InputStream receive, OutputStream send) {
        LanguageServer server = serverFactory.apply(new RealClient(send));
        final ArrayBlockingQueue pending = new ArrayBlockingQueue(10);
        final Message endOfStream = new Message();
        class MessageReader
        implements Runnable {
            MessageReader() {
            }

            void peek(Message message) {
                if (message.method.equals("$/cancelRequest")) {
                    CancelParams params = (CancelParams)gson.fromJson(message.params, CancelParams.class);
                    boolean removed = pending.removeIf(r -> r.id != null && r.id.equals(params.id));
                    if (removed) {
                        LOG.info(String.format("Cancelled request %d, which had not yet started", params.id));
                    } else {
                        LOG.info(String.format("Cannot cancel request %d because it has already started", params.id));
                    }
                }
            }

            private boolean kill() {
                LOG.info("Read stream has been closed, putting kill message onto queue...");
                try {
                    pending.put(endOfStream);
                    return true;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed to put kill message onto queue, will try again...", e);
                    return false;
                }
            }

            @Override
            public void run() {
                LOG.info("Placing incoming messages on queue...");
                while (true) {
                    try {
                        while (true) {
                            String token = LSP.nextToken(receive);
                            Message message = LSP.parseMessage(token);
                            this.peek(message);
                            pending.put(message);
                        }
                    }
                    catch (EndOfStream __) {
                        if (!this.kill()) continue;
                        return;
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                        continue;
                    }
                    break;
                }
            }
        }
        Thread reader = new Thread((Runnable)new MessageReader(), "reader");
        reader.setDaemon(true);
        reader.start();
        LOG.info("Reading messages from queue...");
        boolean hasAsyncWork = false;
        block68: while (true) {
            Message r;
            try {
                r = (Message)pending.poll(200L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (r == endOfStream) {
                LOG.warning("Stream from client has been closed, exiting...");
                break;
            }
            if (r == null) {
                if (!hasAsyncWork) continue;
                server.doAsyncWork();
                hasAsyncWork = false;
                continue;
            }
            hasAsyncWork = true;
            try {
                switch (r.method) {
                    case "initialize": {
                        Object params = (InitializeParams)gson.fromJson(r.params, InitializeParams.class);
                        List<Object> response = server.initialize((InitializeParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "initialized": {
                        server.initialized();
                        break;
                    }
                    case "shutdown": {
                        LOG.warning("Got shutdown message");
                        LSP.respond(send, r.id, null);
                        break;
                    }
                    case "exit": {
                        LOG.warning("Got exit message, exiting...");
                        break block68;
                    }
                    case "workspace/didChangeWorkspaceFolders": {
                        Object params = (DidChangeWorkspaceFoldersParams)gson.fromJson(r.params, DidChangeWorkspaceFoldersParams.class);
                        server.didChangeWorkspaceFolders((DidChangeWorkspaceFoldersParams)params);
                        break;
                    }
                    case "workspace/didChangeConfiguration": {
                        Object params = (DidChangeConfigurationParams)gson.fromJson(r.params, DidChangeConfigurationParams.class);
                        server.didChangeConfiguration((DidChangeConfigurationParams)params);
                        break;
                    }
                    case "workspace/didChangeWatchedFiles": {
                        Object params = (DidChangeWatchedFilesParams)gson.fromJson(r.params, DidChangeWatchedFilesParams.class);
                        server.didChangeWatchedFiles((DidChangeWatchedFilesParams)params);
                        break;
                    }
                    case "workspace/symbol": {
                        Object params = (WorkspaceSymbolParams)gson.fromJson(r.params, WorkspaceSymbolParams.class);
                        List<Object> response = server.workspaceSymbols((WorkspaceSymbolParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/documentLink": {
                        Object params = (DocumentLinkParams)gson.fromJson(r.params, DocumentLinkParams.class);
                        List<Object> response = server.documentLink((DocumentLinkParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/didOpen": {
                        Object params = (DidOpenTextDocumentParams)gson.fromJson(r.params, DidOpenTextDocumentParams.class);
                        server.didOpenTextDocument((DidOpenTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/didChange": {
                        Object params = (DidChangeTextDocumentParams)gson.fromJson(r.params, DidChangeTextDocumentParams.class);
                        server.didChangeTextDocument((DidChangeTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/willSave": {
                        Object params = (WillSaveTextDocumentParams)gson.fromJson(r.params, WillSaveTextDocumentParams.class);
                        server.willSaveTextDocument((WillSaveTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/willSaveWaitUntil": {
                        Object params = (WillSaveTextDocumentParams)gson.fromJson(r.params, WillSaveTextDocumentParams.class);
                        List<Object> response = server.willSaveWaitUntilTextDocument((WillSaveTextDocumentParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/didSave": {
                        Object params = (DidSaveTextDocumentParams)gson.fromJson(r.params, DidSaveTextDocumentParams.class);
                        server.didSaveTextDocument((DidSaveTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/didClose": {
                        Object params = (DidCloseTextDocumentParams)gson.fromJson(r.params, DidCloseTextDocumentParams.class);
                        server.didCloseTextDocument((DidCloseTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/completion": {
                        Object params = (TextDocumentPositionParams)gson.fromJson(r.params, TextDocumentPositionParams.class);
                        List<Object> response = server.completion((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "completionItem/resolve": {
                        Object params = (CompletionItem)gson.fromJson(r.params, CompletionItem.class);
                        List<Object> response = server.resolveCompletionItem((CompletionItem)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/hover": {
                        Object params = (TextDocumentPositionParams)gson.fromJson(r.params, TextDocumentPositionParams.class);
                        List<Object> response = server.hover((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/signatureHelp": {
                        Object params = (TextDocumentPositionParams)gson.fromJson(r.params, TextDocumentPositionParams.class);
                        List<Object> response = server.signatureHelp((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/definition": {
                        Object params = (TextDocumentPositionParams)gson.fromJson(r.params, TextDocumentPositionParams.class);
                        List<Object> response = server.gotoDefinition((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/references": {
                        Object params = (ReferenceParams)gson.fromJson(r.params, ReferenceParams.class);
                        List<Object> response = server.findReferences((ReferenceParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/documentSymbol": {
                        Object params = (DocumentSymbolParams)gson.fromJson(r.params, DocumentSymbolParams.class);
                        List<Object> response = server.documentSymbol((DocumentSymbolParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/codeAction": {
                        Object params = (CodeActionParams)gson.fromJson(r.params, CodeActionParams.class);
                        List<Object> response = server.codeAction((CodeActionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/codeLens": {
                        Object params = (CodeLensParams)gson.fromJson(r.params, CodeLensParams.class);
                        List<Object> response = server.codeLens((CodeLensParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "codeLens/resolve": {
                        Object params = (CodeLens)gson.fromJson(r.params, CodeLens.class);
                        List<Object> response = server.resolveCodeLens((CodeLens)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/prepareRename": {
                        Object params = (TextDocumentPositionParams)gson.fromJson(r.params, TextDocumentPositionParams.class);
                        List<Object> response = server.prepareRename((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/rename": {
                        Object params = (RenameParams)gson.fromJson(r.params, RenameParams.class);
                        List<Object> response = server.rename((RenameParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/formatting": {
                        Object params = (DocumentFormattingParams)gson.fromJson(r.params, DocumentFormattingParams.class);
                        List<Object> response = server.formatting((DocumentFormattingParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/foldingRange": {
                        Object params = (FoldingRangeParams)gson.fromJson(r.params, FoldingRangeParams.class);
                        List<Object> response = server.foldingRange((FoldingRangeParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "$/cancelRequest": {
                        break;
                    }
                    default: {
                        LOG.warning(String.format("Don't know what to do with method `%s`", r.method));
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                if (r.id == null) continue;
                LSP.error(send, r.id, new ResponseError(-32603, e.getMessage(), null));
            }
        }
    }

    static class EndOfStream
    extends RuntimeException {
        EndOfStream() {
        }
    }

    private static class RealClient
    implements LanguageClient {
        final OutputStream send;

        RealClient(OutputStream send) {
            this.send = send;
        }

        @Override
        public void publishDiagnostics(PublishDiagnosticsParams params) {
            LSP.notifyClient(this.send, "textDocument/publishDiagnostics", params);
        }

        @Override
        public void showMessage(ShowMessageParams params) {
            LSP.notifyClient(this.send, "window/showMessage", params);
        }

        @Override
        public void registerCapability(String method, JsonElement options) {
            RegistrationParams params = new RegistrationParams();
            params.id = UUID.randomUUID().toString();
            params.method = method;
            params.registerOptions = options;
            LSP.notifyClient(this.send, "client/registerCapability", params);
        }

        @Override
        public void customNotification(String method, JsonElement params) {
            LSP.notifyClient(this.send, method, params);
        }
    }
}

