/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.markup;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import org.javacs.FileStore;
import org.javacs.lsp.Range;
import org.javacs.markup.RangeHelper;
import org.javacs.markup.SemanticColors;

class Colorizer
extends TreePathScanner<Void, SemanticColors> {
    private final Trees trees;

    Colorizer(JavacTask task) {
        this.trees = Trees.instance(task);
    }

    private void maybeField(Name name, SemanticColors colors) {
        if (name.contentEquals("this") || name.contentEquals("super") || name.contentEquals("class")) {
            return;
        }
        TreePath fromPath = this.getCurrentPath();
        Element toEl = this.trees.getElement(fromPath);
        if (toEl == null) {
            return;
        }
        if (toEl.getKind() != ElementKind.FIELD) {
            return;
        }
        Range range = this.find(fromPath, name);
        if (range == Range.NONE) {
            return;
        }
        colors.fields.add(range);
        if (toEl.getModifiers().contains((Object)Modifier.STATIC)) {
            colors.statics.add(range);
        }
    }

    private Range find(TreePath path, Name name) {
        SourcePositions pos = this.trees.getSourcePositions();
        CompilationUnitTree root = path.getCompilationUnit();
        Tree leaf = path.getLeaf();
        int start = (int)pos.getStartPosition(root, leaf);
        int end = (int)pos.getEndPosition(root, leaf);
        if (leaf instanceof MemberSelectTree) {
            MemberSelectTree select = (MemberSelectTree)leaf;
            start = (int)pos.getEndPosition(root, select.getExpression());
        } else if (leaf instanceof VariableTree) {
            VariableTree declaration = (VariableTree)leaf;
            start = (int)pos.getEndPosition(root, declaration.getType());
        }
        if (start == -1 || end == -1) {
            return Range.NONE;
        }
        Path file = Paths.get(root.getSourceFile().toUri());
        String contents = FileStore.contents(file);
        String region = contents.substring(start, end);
        end = (start += region.indexOf(name.toString())) + name.length();
        return RangeHelper.range(root, start, end);
    }

    @Override
    public Void visitIdentifier(IdentifierTree t, SemanticColors colors) {
        this.maybeField(t.getName(), colors);
        return (Void)super.visitIdentifier(t, colors);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree t, SemanticColors colors) {
        this.maybeField(t.getIdentifier(), colors);
        return (Void)super.visitMemberSelect(t, colors);
    }

    @Override
    public Void visitVariable(VariableTree t, SemanticColors colors) {
        this.maybeField(t.getName(), colors);
        return (Void)super.visitVariable(t, colors);
    }
}

