/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.navigation;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.FindHelper;
import org.javacs.SourceFileObject;
import org.javacs.lsp.Location;
import org.javacs.navigation.NavigationHelper;

public class DefinitionProvider {
    private final CompilerProvider compiler;
    private final Path file;
    private final int line;
    private final int column;
    public static final List<Location> NOT_SUPPORTED = List.of();

    public DefinitionProvider(CompilerProvider compiler, Path file, int line, int column) {
        this.compiler = compiler;
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public List<Location> find() {
        try (CompileTask task = this.compiler.compile(this.file);){
            Element element = NavigationHelper.findElement(task, this.file, this.line, this.column);
            if (element == null) {
                List<Location> list = NOT_SUPPORTED;
                return list;
            }
            if (element.asType().getKind() == TypeKind.ERROR) {
                task.close();
                List<Location> list = this.findError(element);
                return list;
            }
            if (NavigationHelper.isLocal(element)) {
                List<Location> list = this.findDefinitions(task, element);
                return list;
            }
            String className = this.className(element);
            if (className.isEmpty()) {
                List<Location> list = NOT_SUPPORTED;
                return list;
            }
            Optional<JavaFileObject> otherFile = this.compiler.findAnywhere(className);
            if (otherFile.isEmpty()) {
                List<Location> list = List.of();
                return list;
            }
            if (otherFile.get().toUri().equals(this.file.toUri())) {
                List<Location> list = this.findDefinitions(task, element);
                return list;
            }
            task.close();
            List<Location> list = this.findRemoteDefinitions(otherFile.get());
            return list;
        }
    }

    private List<Location> findError(Element element) {
        Name name = element.getSimpleName();
        if (name == null) {
            return NOT_SUPPORTED;
        }
        Element parent = element.getEnclosingElement();
        if (!(parent instanceof TypeElement)) {
            return NOT_SUPPORTED;
        }
        TypeElement type = (TypeElement)parent;
        String className = type.getQualifiedName().toString();
        String memberName = name.toString();
        return this.findAllMembers(className, memberName);
    }

    private List<Location> findAllMembers(String className, String memberName) {
        Optional<JavaFileObject> otherFile = this.compiler.findAnywhere(className);
        if (otherFile.isEmpty()) {
            return List.of();
        }
        SourceFileObject fileAsSource = new SourceFileObject(this.file);
        List<JavaFileObject> sources = List.of(fileAsSource, otherFile.get());
        if (otherFile.get().toString().equals(this.file.toUri())) {
            sources = List.of(fileAsSource);
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        try (CompileTask task = this.compiler.compile(sources);){
            Trees trees = Trees.instance(task.task);
            Elements elements = task.task.getElements();
            TypeElement parentClass = elements.getTypeElement(className);
            for (Element element : elements.getAllMembers(parentClass)) {
                TreePath path;
                if (!element.getSimpleName().contentEquals(memberName) || (path = trees.getPath(element)) == null) continue;
                Location location = FindHelper.location(task, path, memberName);
                locations.add(location);
            }
        }
        return locations;
    }

    private String className(Element element) {
        while (element != null) {
            if (element instanceof TypeElement) {
                TypeElement type = (TypeElement)element;
                return type.getQualifiedName().toString();
            }
            element = element.getEnclosingElement();
        }
        return "";
    }

    private List<Location> findRemoteDefinitions(JavaFileObject otherFile) {
        try (CompileTask task = this.compiler.compile(List.of(new SourceFileObject(this.file), otherFile));){
            Element element = NavigationHelper.findElement(task, this.file, this.line, this.column);
            List<Location> list = this.findDefinitions(task, element);
            return list;
        }
    }

    private List<Location> findDefinitions(CompileTask task, Element element) {
        Trees trees = Trees.instance(task.task);
        TreePath path = trees.getPath(element);
        if (path == null) {
            return List.of();
        }
        Name name = element.getSimpleName();
        if (name.contentEquals("<init>")) {
            name = element.getEnclosingElement().getSimpleName();
        }
        return List.of(FindHelper.location(task, path, name));
    }
}

