/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.navigation;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.javacs.CompileTask;
import org.javacs.FindNameAt;

class NavigationHelper {
    NavigationHelper() {
    }

    static Element findElement(CompileTask task, Path file, int line, int column) {
        for (CompilationUnitTree root : task.roots) {
            if (!root.getSourceFile().toUri().equals(file.toUri())) continue;
            Trees trees = Trees.instance(task.task);
            long cursor = root.getLineMap().getPosition(line, column);
            TreePath path = (TreePath)new FindNameAt(task).scan(root, Long.valueOf(cursor));
            if (path == null) {
                return null;
            }
            return trees.getElement(path);
        }
        throw new RuntimeException("file not found");
    }

    static boolean isLocal(Element element) {
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return true;
        }
        switch (element.getKind()) {
            case EXCEPTION_PARAMETER: 
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case TYPE_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    static boolean isMember(Element element) {
        switch (element.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: 
            case METHOD: 
            case CONSTRUCTOR: {
                return true;
            }
        }
        return false;
    }

    static boolean isType(Element element) {
        switch (element.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return true;
            }
        }
        return false;
    }
}

