/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.navigation;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.FindHelper;
import org.javacs.lsp.Location;
import org.javacs.navigation.FindReferences;
import org.javacs.navigation.NavigationHelper;

public class ReferenceProvider {
    private final CompilerProvider compiler;
    private final Path file;
    private final int line;
    private final int column;
    public static final List<Location> NOT_SUPPORTED = List.of();

    public ReferenceProvider(CompilerProvider compiler, Path file, int line, int column) {
        this.compiler = compiler;
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public List<Location> find() {
        try (CompileTask task = this.compiler.compile(this.file);){
            Element element = NavigationHelper.findElement(task, this.file, this.line, this.column);
            if (element == null) {
                List<Location> list = NOT_SUPPORTED;
                return list;
            }
            if (NavigationHelper.isLocal(element)) {
                List<Location> list = this.findReferences(task);
                return list;
            }
            if (NavigationHelper.isType(element)) {
                TypeElement type = (TypeElement)element;
                String className = type.getQualifiedName().toString();
                task.close();
                List<Location> list = this.findTypeReferences(className);
                return list;
            }
            if (NavigationHelper.isMember(element)) {
                TypeElement parentClass = (TypeElement)element.getEnclosingElement();
                String className = parentClass.getQualifiedName().toString();
                String memberName = element.getSimpleName().toString();
                if (memberName.equals("<init>")) {
                    memberName = parentClass.getSimpleName().toString();
                }
                task.close();
                List<Location> list = this.findMemberReferences(className, memberName);
                return list;
            }
            List<Location> list = NOT_SUPPORTED;
            return list;
        }
    }

    private List<Location> findTypeReferences(String className) {
        Path[] files = this.compiler.findTypeReferences(className);
        if (files.length == 0) {
            return List.of();
        }
        try (CompileTask task = this.compiler.compile(files);){
            List<Location> list = this.findReferences(task);
            return list;
        }
    }

    private List<Location> findMemberReferences(String className, String memberName) {
        Path[] files = this.compiler.findMemberReferences(className, memberName);
        if (files.length == 0) {
            return List.of();
        }
        try (CompileTask task = this.compiler.compile(files);){
            List<Location> list = this.findReferences(task);
            return list;
        }
    }

    private List<Location> findReferences(CompileTask task) {
        Element element = NavigationHelper.findElement(task, this.file, this.line, this.column);
        ArrayList paths = new ArrayList();
        for (CompilationUnitTree root : task.roots) {
            new FindReferences(task.task, element).scan(root, paths);
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        for (TreePath p : paths) {
            locations.add(FindHelper.location(task, p));
        }
        return locations;
    }
}

