/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.FindHelper;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.Rewrite;

public class AddException
implements Rewrite {
    final String className;
    final String methodName;
    final String[] erasedParameterTypes;
    final String exceptionType;

    public AddException(String className, String methodName, String[] erasedParameterTypes, String exceptionType) {
        this.className = className;
        this.methodName = methodName;
        this.erasedParameterTypes = erasedParameterTypes;
        this.exceptionType = exceptionType;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        Path file = compiler.findTypeDeclaration(this.className);
        if (file == CompilerProvider.NOT_FOUND) {
            return CANCELLED;
        }
        try (CompileTask task = compiler.compile(file);){
            Trees trees = Trees.instance(task.task);
            ExecutableElement methodElement = FindHelper.findMethod(task, this.className, this.methodName, this.erasedParameterTypes);
            MethodTree methodTree = trees.getTree(methodElement);
            SourcePositions pos = trees.getSourcePositions();
            LineMap lines = task.root().getLineMap();
            long startBody = pos.getStartPosition(task.root(), methodTree.getBody());
            int line = (int)lines.getLineNumber(startBody);
            int column = (int)lines.getColumnNumber(startBody);
            Position insertPos = new Position(line - 1, column - 1);
            String packageName = "";
            String simpleName = this.exceptionType;
            int lastDot = simpleName.lastIndexOf(46);
            if (lastDot != -1) {
                packageName = this.exceptionType.substring(0, lastDot);
                simpleName = this.exceptionType.substring(lastDot + 1);
            }
            String insertText = methodTree.getThrows().isEmpty() ? "throws " + simpleName + " " : ", " + simpleName + " ";
            TextEdit insertThrows = new TextEdit(new Range(insertPos, insertPos), insertText);
            TextEdit[] edits = new TextEdit[]{insertThrows};
            Map<Path, TextEdit[]> map = Map.of(file, edits);
            return map;
        }
    }
}

