/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.FindHelper;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.Rewrite;

public class AddSuppressWarningAnnotation
implements Rewrite {
    final String className;
    final String methodName;
    final String[] erasedParameterTypes;

    public AddSuppressWarningAnnotation(String className, String methodName, String[] erasedParameterTypes) {
        this.className = className;
        this.methodName = methodName;
        this.erasedParameterTypes = erasedParameterTypes;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        Path file = compiler.findTypeDeclaration(this.className);
        if (file == CompilerProvider.NOT_FOUND) {
            return CANCELLED;
        }
        try (CompileTask task = compiler.compile(file);){
            Trees trees = Trees.instance(task.task);
            ExecutableElement methodElement = FindHelper.findMethod(task, this.className, this.methodName, this.erasedParameterTypes);
            MethodTree methodTree = trees.getTree(methodElement);
            SourcePositions pos = trees.getSourcePositions();
            int startMethod = (int)pos.getStartPosition(task.root(), methodTree);
            LineMap lines = task.root().getLineMap();
            int line = (int)lines.getLineNumber(startMethod);
            int column = (int)lines.getColumnNumber(startMethod);
            int startLine = (int)lines.getStartPosition(line);
            String indent = " ".repeat(startMethod - startLine);
            String insertText = "@SuppressWarnings(\"unchecked\")\n" + indent;
            Position insertPoint = new Position(line - 1, column - 1);
            TextEdit insert = new TextEdit(new Range(insertPoint, insertPoint), insertText);
            TextEdit[] edits = new TextEdit[]{insert};
            Map<Path, TextEdit[]> map = Map.of(file, edits);
            return map;
        }
    }
}

