/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.LineMap;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.FindMissingOverride;
import org.javacs.rewrite.Rewrite;

public class AutoAddOverrides
implements Rewrite {
    private final Path file;

    public AutoAddOverrides(Path file) {
        this.file = file;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        try (CompileTask task = compiler.compile(this.file);){
            ArrayList<TreePath> missing = new ArrayList<TreePath>();
            new FindMissingOverride(task.task).scan(task.root(), missing);
            List<TextEdit> list = this.addOverrides(task, missing);
            Map<Path, TextEdit[]> map = Map.of(this.file, list.toArray(new TextEdit[list.size()]));
            return map;
        }
    }

    private List<TextEdit> addOverrides(CompileTask task, List<TreePath> missing) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        SourcePositions pos = Trees.instance(task.task).getSourcePositions();
        for (TreePath t : missing) {
            LineMap lines = t.getCompilationUnit().getLineMap();
            long methodStart = pos.getStartPosition(t.getCompilationUnit(), t.getLeaf());
            long insertLine = lines.getLineNumber(methodStart);
            long indent = methodStart - lines.getPosition(insertLine, 0L);
            StringBuilder insertText = new StringBuilder();
            int i = 0;
            while ((long)i < indent) {
                insertText.append(' ');
                ++i;
            }
            insertText.append("@Override");
            insertText.append('\n');
            Position insertPosition = new Position((int)insertLine - 1, 0);
            TextEdit insert = new TextEdit(new Range(insertPosition, insertPosition), insertText.toString());
            edits.add(insert);
        }
        return edits;
    }
}

