/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.FindUsedImports;
import org.javacs.rewrite.Rewrite;

public class AutoFixImports
implements Rewrite {
    final Path file;
    private static final Logger LOG = Logger.getLogger("main");

    public AutoFixImports(Path file) {
        this.file = file;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        LOG.info("Fix imports in " + String.valueOf(this.file) + "...");
        try (CompileTask task = compiler.compile(this.file);){
            Set<String> used = this.usedImports(task);
            Set<String> unresolved = this.unresolvedNames(task);
            Map<String, String> resolved = this.resolveNames(compiler, unresolved);
            ArrayList<String> all = new ArrayList<String>();
            all.addAll(used);
            all.addAll(resolved.values());
            all.sort(String::compareTo);
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            edits.addAll(this.deleteImports(task));
            edits.add(this.insertImports(task, all));
            Map<Path, TextEdit[]> map = Map.of(this.file, edits.toArray(new TextEdit[edits.size()]));
            return map;
        }
    }

    private Set<String> usedImports(CompileTask task) {
        HashSet<String> used = new HashSet<String>();
        new FindUsedImports(task.task).scan(task.root(), used);
        return used;
    }

    private Set<String> unresolvedNames(CompileTask task) {
        HashSet<String> names = new HashSet<String>();
        for (Diagnostic<? extends JavaFileObject> d : task.diagnostics) {
            CharSequence contents;
            if (!d.getCode().equals("compiler.err.cant.resolve.location") || !d.getSource().toUri().equals(this.file.toUri())) continue;
            int start = (int)d.getStartPosition();
            int end = (int)d.getEndPosition();
            try {
                contents = d.getSource().getCharContent(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String name = contents.subSequence(start, end).toString();
            if (!name.matches("[A-Z]\\w+")) continue;
            names.add(name);
        }
        return names;
    }

    private Map<String, String> resolveNames(CompilerProvider compiler, Set<String> unresolved) {
        HashMap<String, String> resolved = new HashMap<String, String>();
        Set<String> alreadyImported = compiler.imports();
        for (String className : unresolved) {
            ArrayList<String> candidates = new ArrayList<String>();
            for (String i : alreadyImported) {
                if (!i.endsWith("." + className)) continue;
                candidates.add(i);
            }
            if (candidates.isEmpty()) continue;
            if (candidates.size() > 1) {
                LOG.warning("..." + className + " is ambiguous between " + String.join((CharSequence)", ", candidates));
                continue;
            }
            LOG.info("...resolve " + className + " to " + (String)candidates.get(0));
            resolved.put(className, (String)candidates.get(0));
        }
        return resolved;
    }

    private List<TextEdit> deleteImports(CompileTask task) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        SourcePositions pos = Trees.instance(task.task).getSourcePositions();
        CompilationUnitTree root = task.root();
        for (ImportTree importTree : root.getImports()) {
            if (importTree.isStatic()) continue;
            long start = pos.getStartPosition(root, importTree);
            int line = (int)root.getLineMap().getLineNumber(start);
            TextEdit delete = new TextEdit(new Range(new Position(line - 1, 0), new Position(line, 0)), "");
            edits.add(delete);
        }
        return edits;
    }

    private TextEdit insertImports(CompileTask task, List<String> qualifiedNames) {
        Position pos = this.insertPosition(task);
        StringBuilder text = new StringBuilder();
        for (String i : qualifiedNames) {
            text.append("import ").append(i).append(";\n");
        }
        return new TextEdit(new Range(pos, pos), text.toString());
    }

    private Position insertPosition(CompileTask task) {
        SourcePositions pos = Trees.instance(task.task).getSourcePositions();
        CompilationUnitTree root = task.root();
        for (ImportTree importTree : root.getImports()) {
            if (importTree.isStatic()) continue;
            long start = pos.getStartPosition(root, importTree);
            int line = (int)root.getLineMap().getLineNumber(start);
            return new Position(line - 1, 0);
        }
        if (root.getPackage() != null) {
            long end = pos.getEndPosition(root, root.getPackage());
            int line = (int)root.getLineMap().getLineNumber(end) + 1;
            return new Position(line - 1, 0);
        }
        return new Position(0, 0);
    }
}

