/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.javacs.CompilerProvider;
import org.javacs.ParseTask;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.ConvertVariableToStatement;
import org.javacs.rewrite.Rewrite;

public class ConvertFieldToBlock
implements Rewrite {
    final Path file;
    final int position;

    public ConvertFieldToBlock(Path file, int position) {
        this.file = file;
        this.position = position;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        ParseTask task = compiler.parse(this.file);
        Trees trees = Trees.instance(task.task);
        SourcePositions pos = trees.getSourcePositions();
        LineMap lines = task.root.getLineMap();
        VariableTree variable = ConvertVariableToStatement.findVariable(task, this.position);
        if (variable == null) {
            return CANCELLED;
        }
        ExpressionTree expression = variable.getInitializer();
        if (!ConvertVariableToStatement.isExpressionStatement(expression)) {
            return CANCELLED;
        }
        long start = pos.getStartPosition(task.root, variable);
        long end = pos.getStartPosition(task.root, expression);
        int startLine = (int)lines.getLineNumber(start);
        int startColumn = (int)lines.getColumnNumber(start);
        Position startPos = new Position(startLine - 1, startColumn - 1);
        int endLine = (int)lines.getLineNumber(end);
        int endColumn = (int)lines.getColumnNumber(end);
        Position endPos = new Position(endLine - 1, endColumn - 1);
        Range deleteLhs = new Range(startPos, endPos);
        TextEdit fixLhs = new TextEdit(deleteLhs, "{ ");
        if (variable.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            fixLhs.newText = "static { ";
        }
        long right = pos.getEndPosition(task.root, variable);
        int rightLine = (int)lines.getLineNumber(right);
        int rightColumn = (int)lines.getColumnNumber(right);
        Position rightPos = new Position(rightLine - 1, rightColumn - 1);
        Range insertRight = new Range(rightPos, rightPos);
        TextEdit fixRhs = new TextEdit(insertRight, " }");
        TextEdit[] edits = new TextEdit[]{fixLhs, fixRhs};
        return Map.of(this.file, edits);
    }
}

