/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.util.List;
import java.util.StringJoiner;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;

class EditHelper {
    final JavacTask task;

    EditHelper(JavacTask task) {
        this.task = task;
    }

    TextEdit removeTree(CompilationUnitTree root, Tree remove) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        LineMap lines = root.getLineMap();
        long start = pos.getStartPosition(root, remove);
        long end = pos.getEndPosition(root, remove);
        int startLine = (int)lines.getLineNumber(start);
        int startColumn = (int)lines.getColumnNumber(start);
        Position startPos = new Position(startLine - 1, startColumn - 1);
        int endLine = (int)lines.getLineNumber(end);
        int endColumn = (int)lines.getColumnNumber(end);
        Position endPos = new Position(endLine - 1, endColumn - 1);
        Range range = new Range(startPos, endPos);
        return new TextEdit(range, "");
    }

    static String printMethod(ExecutableElement method, ExecutableType parameterizedType, MethodTree source) {
        StringBuilder buf = new StringBuilder();
        buf.append("\n@Override\n");
        if (method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            buf.append("public ");
        }
        if (method.getModifiers().contains((Object)Modifier.PROTECTED)) {
            buf.append("protected ");
        }
        buf.append(EditHelper.printType(parameterizedType.getReturnType())).append(" ");
        buf.append(method.getSimpleName()).append("(");
        buf.append(EditHelper.printParameters(parameterizedType, source));
        buf.append(") {\n    // TODO\n}");
        return buf.toString();
    }

    private static String printParameters(ExecutableType method, MethodTree source) {
        StringJoiner join = new StringJoiner(", ");
        for (int i = 0; i < method.getParameterTypes().size(); ++i) {
            String type = EditHelper.printType(method.getParameterTypes().get(i));
            Name name = source.getParameters().get(i).getName();
            join.add(type + " " + String.valueOf(name));
        }
        return join.toString();
    }

    static String printType(TypeMirror type) {
        if (type instanceof DeclaredType) {
            DeclaredType declared = (DeclaredType)type;
            Object string = EditHelper.printTypeName((TypeElement)declared.asElement());
            if (!declared.getTypeArguments().isEmpty()) {
                string = (String)string + "<" + EditHelper.printTypeParameters(declared.getTypeArguments()) + ">";
            }
            return string;
        }
        if (type instanceof ArrayType) {
            ArrayType array = (ArrayType)type;
            return EditHelper.printType(array.getComponentType()) + "[]";
        }
        return type.toString();
    }

    private static String printTypeParameters(List<? extends TypeMirror> arguments) {
        StringJoiner join = new StringJoiner(", ");
        for (TypeMirror typeMirror : arguments) {
            join.add(EditHelper.printType(typeMirror));
        }
        return join.toString();
    }

    static String printTypeName(TypeElement type) {
        if (type.getEnclosingElement() instanceof TypeElement) {
            return EditHelper.printTypeName((TypeElement)type.getEnclosingElement()) + "." + String.valueOf(type.getSimpleName());
        }
        return type.getSimpleName().toString();
    }

    static int indent(JavacTask task, CompilationUnitTree root, ClassTree leaf) {
        SourcePositions pos = Trees.instance(task).getSourcePositions();
        LineMap lines = root.getLineMap();
        long startClass = pos.getStartPosition(root, leaf);
        long startLine = lines.getStartPosition(lines.getLineNumber(startClass));
        return (int)(startClass - startLine);
    }

    static Position insertBefore(JavacTask task, CompilationUnitTree root, Tree member) {
        SourcePositions pos = Trees.instance(task).getSourcePositions();
        LineMap lines = root.getLineMap();
        long start = pos.getStartPosition(root, member);
        int line = (int)lines.getLineNumber(start);
        return new Position(line - 1, 0);
    }

    static Position insertAfter(JavacTask task, CompilationUnitTree root, Tree member) {
        SourcePositions pos = Trees.instance(task).getSourcePositions();
        LineMap lines = root.getLineMap();
        long end = pos.getEndPosition(root, member);
        int line = (int)lines.getLineNumber(end);
        return new Position(line, 0);
    }

    static Position insertAtEndOfClass(JavacTask task, CompilationUnitTree root, ClassTree leaf) {
        SourcePositions pos = Trees.instance(task).getSourcePositions();
        LineMap lines = root.getLineMap();
        long end = pos.getEndPosition(root, leaf);
        int line = (int)lines.getLineNumber(end);
        return new Position(line - 1, 0);
    }
}

